/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming;

import LandLord.landlord.paperlib.PaperLib;
import biz.princeps.landlord.api.ClaimType;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IVaultManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.api.events.LandPostClaimEvent;
import biz.princeps.landlord.api.events.LandPreClaimEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.commands.claiming.Shop;
import biz.princeps.landlord.commands.homes.SetHome;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Chunk;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Claim
extends LandlordCommand {
    private final boolean overrideConfirmations;
    private final IWorldGuardManager wg;
    private final IVaultManager vault;

    public Claim(ILandLord plugin, boolean overrideConfirmations) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Claim.name"), plugin.getConfig().getString("CommandSettings.Claim.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Claim.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Claim.aliases")));
        this.overrideConfirmations = overrideConfirmations;
        this.wg = plugin.getWGManager();
        this.vault = plugin.getVaultManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            PaperLib.getChunkAtAsync(properties.getPlayer().getLocation()).thenAccept(chunk -> this.onClaim(properties.getPlayer(), (Chunk)chunk));
        }
    }

    public void onClaim(Player player, Chunk chunk) {
        if (!this.overrideConfirmations && this.isDisabledWorld(player)) {
            return;
        }
        if (!this.isInsideWorld(player, chunk)) {
            return;
        }
        IOwnedLand ol = this.wg.getRegion(chunk);
        String landName = this.wg.getLandName(chunk);
        String confirmcmd = PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(Landlordbase.Confirm.class);
        int regionCount = this.wg.getRegionCount(player.getUniqueId());
        int worldRegionCount = this.wg.getRegionCount(player.getUniqueId(), player.getWorld());
        if (!(this.plugin.getConfig().getBoolean("CommandSettings.Claim.allowOverlap", false) || this.wg.canClaim(player, chunk) || ol != null && (this.plugin.getPlayerManager().isInactiveSync(ol.getOwner()) || ol.getPrice() != -1.0))) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.notAllowed"));
            return;
        }
        if (!this.hasLimitPermissions(player, regionCount)) {
            return;
        }
        if (!this.hasClaims(player, regionCount)) {
            return;
        }
        if (!this.isAdjacentLandOwned(player, chunk, worldRegionCount)) {
            return;
        }
        if (!this.isGapBetweenLands(player, chunk)) {
            return;
        }
        LandPreClaimEvent event = new LandPreClaimEvent(player, chunk);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (ol == null) {
            double calculatedCost = Options.isVaultEnabled() ? this.plugin.getCostManager().calculateCost(player.getUniqueId()) : 0.0;
            String Desc = this.lm.getString(player, "Commands.Claim.confirmation").replace("%chunk%", landName).replace("%price%", this.vault.format(calculatedCost));
            if (!this.hasMoney(player, calculatedCost, landName, chunk)) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onNormalClaim") && !this.overrideConfirmations) {
                PrincepsLib.getConfirmationManager().draw(player, Desc, Desc, p -> {
                    this.performNormalClaim(player, chunk, calculatedCost, landName);
                    p.closeInventory();
                }, p -> {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.aborted"));
                    p.closeInventory();
                }, confirmcmd);
            } else {
                this.performNormalClaim(player, chunk, calculatedCost, landName);
            }
        } else if (ol.getPrice() > -1.0 && Options.isVaultEnabled()) {
            double calculatedCost = ol.getPrice();
            String Desc = this.lm.getString(player, "Commands.Claim.confirmation").replace("%chunk%", landName).replace("%price%", this.vault.format(calculatedCost));
            if (!this.hasMoney(player, calculatedCost, landName, chunk)) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onNormalClaim") && !this.overrideConfirmations) {
                PrincepsLib.getConfirmationManager().draw(player, Desc, Desc, p -> {
                    this.performAdvertisedClaim(player, ol);
                    p.closeInventory();
                }, p -> {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.aborted"));
                    p.closeInventory();
                }, confirmcmd);
            } else {
                this.performAdvertisedClaim(player, ol);
            }
        } else {
            if (ol.isOwner(player.getUniqueId())) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.alreadyClaimed").replace("%owner%", ol.getOwnersString()));
                return;
            }
            this.plugin.getPlayerManager().getOffline(ol.getOwner(), offline -> {
                boolean isInactive = this.plugin.getPlayerManager().isInactive(offline.getLastSeen());
                int inactiveDays = this.plugin.getPlayerManager().getInactiveRemainingDays(offline.getLastSeen());
                if (isInactive) {
                    double costForBuyer = this.plugin.getCostManager().calculateCost(player.getUniqueId());
                    double payBackForInactive = this.plugin.getCostManager().calculateCost(ol.getOwner());
                    String Desc = this.lm.getString(player, "Commands.Claim.confirmation").replace("%chunk%", landName).replace("%price%", this.vault.format(costForBuyer));
                    String originalOwner = this.plugin.getServer().getOfflinePlayer(ol.getOwner()).getName();
                    if (!this.hasMoney(player, costForBuyer, landName, chunk)) {
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onBuyUp") && !this.overrideConfirmations) {
                        PrincepsLib.getConfirmationManager().draw(player, Desc, Desc, p -> {
                            this.handleInactiveClaim(player, ol, costForBuyer, payBackForInactive, originalOwner);
                            player.closeInventory();
                        }, p -> {
                            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.aborted"));
                            player.closeInventory();
                        }, confirmcmd);
                    } else {
                        this.handleInactiveClaim(player, ol, costForBuyer, payBackForInactive, originalOwner);
                    }
                } else {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.notYetInactive").replace("%owner%", ol.getOwnersString()).replace("%days%", "" + inactiveDays));
                }
            });
        }
    }

    private boolean hasMoney(Player player, double costForBuyer, String landName, Chunk chunk) {
        if (Options.isVaultEnabled()) {
            if (this.vault.hasBalance(player, costForBuyer)) {
                return true;
            }
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.notEnoughMoney").replace("%money%", this.vault.format(costForBuyer)).replace("%chunk%", landName).replace("%location%", this.wg.formatLocation(chunk)));
            return false;
        }
        return true;
    }

    private void handleInactiveClaim(Player player, IOwnedLand ol, double costForBuyer, double payBackForInactive, String originalOwner) {
        Chunk chunk = ol.getChunk();
        this.vault.take(player, costForBuyer);
        this.vault.give(ol.getOwner(), payBackForInactive, player.getWorld());
        ol.replaceOwner(player.getUniqueId());
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.boughtUp").replace("%player%", originalOwner).replace("%price%", this.vault.format(costForBuyer)).replace("%chunk%", ol.getName()).replace("%location%", this.wg.formatLocation(chunk)));
        ol.highlightLand(chunk, player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.claim.particle").toUpperCase()));
        this.plugin.getMapManager().updateAll();
        final LandPostClaimEvent postEvent = new LandPostClaimEvent(player, ol, ClaimType.INACTIVE);
        new BukkitRunnable(){

            public void run() {
                Claim.this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
            }
        }.runTask((Plugin)this.plugin);
    }

    private void performAdvertisedClaim(Player player, IOwnedLand ol) {
        Chunk chunk = ol.getChunk();
        this.vault.take(player, ol.getPrice());
        this.vault.give(ol.getOwner(), ol.getPrice(), player.getWorld());
        Player pp = this.plugin.getServer().getPlayer(ol.getOwner());
        ol.replaceOwner(player.getUniqueId());
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.success").replace("%chunk%", ol.getName()).replace("%location%", this.wg.formatLocation(chunk)).replace("%world%", chunk.getWorld().getName()));
        if (pp.isOnline()) {
            this.lm.sendMessage((CommandSender)pp, this.lm.getString(pp, "Commands.Claim.p2pSuccess").replace("%player%", player.getName()).replace("%chunk%", ol.getName()).replace("%location%", this.wg.formatLocation(chunk)).replace("%world%", chunk.getWorld().getName()).replace("%price%", this.vault.format(ol.getPrice())));
        }
        ol.setPrice(-1.0);
        ol.highlightLand(chunk, player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.claim.particle").toUpperCase()));
        this.plugin.getMapManager().updateAll();
        LandPostClaimEvent postEvent = new LandPostClaimEvent(player, ol, ClaimType.ADVERTISED);
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    private void performNormalClaim(Player player, Chunk chunk, double calculatedCost, String landName) {
        if (Options.isVaultEnabled() && calculatedCost > 0.0) {
            this.vault.take(player, calculatedCost);
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.moneyTook").replace("%money%", this.vault.format(calculatedCost)).replace("%chunk%", landName).replace("%location%", this.wg.formatLocation(chunk)));
        }
        IOwnedLand claim = this.wg.claim(chunk, player.getUniqueId());
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.success").replace("%chunk%", claim.getName()).replace("%location%", this.wg.formatLocation(chunk)).replace("%world%", chunk.getWorld().getName()));
        if (this.plugin.getConfig().getBoolean("Particles.claim.enabled")) {
            claim.highlightLand(chunk, player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.claim.particle").toUpperCase()));
        }
        if (Options.enabled_homes() && this.plugin.getConfig().getBoolean("Homes.enableAutoSetHome", false) && this.plugin.getPlayerManager().get(player.getUniqueId()).getHome() == null) {
            this.plugin.getServer().dispatchCommand((CommandSender)player, PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(SetHome.class).substring(1));
        }
        if (this.plugin.getConfig().getBoolean("CommandSettings.Claim.enableDelimit")) {
            this.plugin.getDelimitationManager().delimit(player, chunk);
        }
        this.plugin.getMapManager().updateAll();
        LandPostClaimEvent postEvent = new LandPostClaimEvent(player, claim, ClaimType.FREE_LAND);
        this.plugin.getServer().getPluginManager().callEvent((Event)postEvent);
    }

    private boolean hasLimitPermissions(Player player, int regionCount) {
        int highestAllowedLandCount = this.plugin.getPlayerManager().getMaxClaimPermission(player);
        if (regionCount >= highestAllowedLandCount) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.hardcap").replace("%regions%", highestAllowedLandCount + ""));
            return false;
        }
        return true;
    }

    private boolean hasClaims(Player player, int regionCount) {
        if (this.plugin.getConfig().getBoolean("Claims.enable") && Options.isVaultEnabled()) {
            int claims = this.plugin.getPlayerManager().get(player.getUniqueId()).getClaims();
            if (regionCount >= claims) {
                ComponentBuilder builder = new ComponentBuilder(this.lm.getString(player, "Commands.Claim.limit").replace("%regions%", regionCount + "").replace("%claims%", claims + "")).color(ChatColor.YELLOW).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(Shop.class)));
                this.plugin.getUtilsManager().sendBasecomponent(player, builder.create());
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean isAdjacentLandOwned(Player player, Chunk chunk, int amountOfOwnedLands) {
        if (this.plugin.getConfig().getBoolean("CommandSettings.Claim.claimOnlyAdjacent") && amountOfOwnedLands > 0) {
            boolean hasNearbyLand = false;
            IOwnedLand[] surroundings = this.wg.getSurroundings(chunk);
            for (int i = 1; i < surroundings.length; ++i) {
                IOwnedLand adjLand = surroundings[i];
                if (adjLand == null || !adjLand.isOwner(player.getUniqueId())) continue;
                hasNearbyLand = true;
                break;
            }
            if (!hasNearbyLand) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.onlyClaimAdjacentChunks").replace("%land%", this.wg.getLandName(chunk)));
                return false;
            }
        }
        return true;
    }

    private boolean isGapBetweenLands(Player player, Chunk chunk) {
        if (!this.plugin.getConfig().getBoolean("CommandSettings.Claim.needsGapBetweenOwners")) {
            return true;
        }
        int radius = this.plugin.getConfig().getInt("CommandSettings.Claim.customGapRadius");
        boolean differentOwner = false;
        Map<Chunk, IOwnedLand> nearbyLands = this.wg.getNearbyLands(chunk, radius, radius);
        for (IOwnedLand adjLand : nearbyLands.values()) {
            if (adjLand == null || adjLand.isOwner(player.getUniqueId())) continue;
            differentOwner = true;
            break;
        }
        if (differentOwner) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.needsGap").replace("%land%", this.wg.getLandName(chunk)));
            return false;
        }
        return true;
    }
}

