/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.admin;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Update
extends LandlordCommand {
    private final ILandLord plugin;

    public Update(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Update.name"), plugin.getConfig().getString("CommandSettings.Update.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Update.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Update.aliases")));
        this.plugin = plugin;
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        try {
            String option;
            switch (option = arguments.get(0)) {
                case "-u": {
                    this.onUpdateLands(properties.getCommandSender());
                    break;
                }
                case "-r": {
                    this.onResetLands(properties.getCommandSender());
                    break;
                }
                case "-c": {
                    this.onReclaimLands(properties.getCommandSender());
                    break;
                }
                default: {
                    properties.sendUsage();
                    break;
                }
            }
        }
        catch (ArgumentsOutOfBoundsException e) {
            properties.sendUsage();
        }
    }

    private void onUpdateLands(final CommandSender issuer) {
        new BukkitRunnable(){

            public void run() {
                issuer.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fStarting to update lands...");
                for (IOwnedLand ownedLand : Update.this.getSusceptibleLands()) {
                    ownedLand.updateFlags(ownedLand.getOwner());
                }
                issuer.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fFinished updating lands!");
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void onResetLands(final CommandSender sender) {
        new BukkitRunnable(){

            public void run() {
                sender.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fStarting to reset lands... Please wait :)");
                for (IOwnedLand ownedLand : Update.this.getSusceptibleLands()) {
                    ownedLand.initFlags(ownedLand.getOwner());
                }
                sender.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fFinished resetting lands!");
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void onReclaimLands(final CommandSender sender) {
        new BukkitRunnable(){

            public void run() {
                sender.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fStarting to reclaim lands... Please wait :)");
                for (IOwnedLand ownedLand : Update.this.getSusceptibleLands()) {
                    ownedLand.reclaim();
                }
                sender.sendMessage("\u00a78[\u00a7c\u00a7l!\u00a78] \u00a7fFinished reclaiming lands!");
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private Set<IOwnedLand> getSusceptibleLands() {
        return this.plugin.getServer().getWorlds().stream().filter(world -> !this.isDisabledWorld((World)world)).map(world -> this.plugin.getWGManager().getRegions((World)world)).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

