/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.admin;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IVaultManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GiveClaims
extends LandlordCommand {
    private final IVaultManager vault;

    public GiveClaims(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.GiveClaims.name"), plugin.getConfig().getString("CommandSettings.GiveClaims.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.GiveClaims.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.GiveClaims.aliases")));
        this.vault = this.plugin.getVaultManager();
    }

    @Override
    public void onCommand(Properties issuer, Arguments args) {
        if (!Options.isVaultEnabled() || !Options.enabled_shop()) {
            this.plugin.getLogger().info("Vault or the shop system is disabled! Therefore you cant execute giveclaims.");
            return;
        }
        switch (args.size()) {
            case 3: {
                int amount;
                double cost;
                String target;
                try {
                    target = args.get(0);
                    cost = args.getDouble(1);
                    amount = args.getInt(2);
                }
                catch (ArgumentsOutOfBoundsException e) {
                    issuer.sendUsage();
                    return;
                }
                Player player = this.plugin.getServer().getPlayer(target);
                if (player == null || !this.checkPermission(player, amount)) break;
                if (this.vault.hasBalance(player, cost)) {
                    this.vault.take(player, cost);
                    this.lm.sendMessage((CommandSender)player, this.plugin.getLangManager().getString("Shop.success").replace("%number%", amount + "").replace("%cost%", this.vault.format(cost)));
                    player.closeInventory();
                    this.addClaims(issuer, target, amount);
                    break;
                }
                this.lm.sendMessage((CommandSender)player, this.plugin.getLangManager().getString("Shop.notEnoughMoney").replace("%number%", amount + "").replace("%cost%", this.vault.format(cost)));
                player.closeInventory();
                return;
            }
            case 2: {
                int amount;
                String target;
                try {
                    target = args.get(0);
                    amount = args.getInt(1);
                }
                catch (ArgumentsOutOfBoundsException e) {
                    issuer.sendUsage();
                    return;
                }
                if (this.plugin.getServer().getPlayer(target) == null) break;
                this.addClaims(issuer, target, amount);
                break;
            }
            case 1: {
                int amount;
                try {
                    amount = args.getInt(0);
                }
                catch (Exception e) {
                    issuer.sendUsage();
                    return;
                }
                if (issuer.isPlayer()) {
                    this.addClaims(issuer, issuer.getPlayer().getName(), amount);
                    break;
                }
                issuer.sendUsage();
                break;
            }
            default: {
                issuer.sendUsage();
            }
        }
    }

    private void addClaims(Properties issuer, String target, int amount) {
        IPlayer lPlayer;
        Player player = this.plugin.getServer().getPlayer(target);
        IPlayer iPlayer = lPlayer = player != null ? this.plugin.getPlayerManager().get(player.getUniqueId()) : null;
        if (player != null && player.isOnline() && lPlayer != null) {
            lPlayer.addClaims(amount);
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.GiveClaims.success").replace("%amount%", String.valueOf(amount)));
        } else {
            this.plugin.getPlayerManager().getOffline(target, offline -> {
                if (offline != null) {
                    offline.addClaims(amount);
                    this.plugin.getPlayerManager().save((IPlayer)offline, true);
                    OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(offline.getUuid());
                    if (op.isOnline()) {
                        this.lm.sendMessage((CommandSender)op.getPlayer(), this.lm.getString(op.getPlayer(), "Commands.GiveClaims.success").replace("%amount%", String.valueOf(amount)));
                    }
                } else if (issuer.getPlayer() != null) {
                    this.lm.sendMessage((CommandSender)issuer.getPlayer(), this.lm.getString(issuer.getPlayer(), "Commands.GiveClaims.noPlayer"));
                }
            });
        }
    }

    private boolean checkPermission(Player player, int amount) {
        int highestAllowedLandCount;
        int claimcount = this.plugin.getPlayerManager().get(player.getUniqueId()).getClaims();
        if (claimcount + amount > (highestAllowedLandCount = this.plugin.getPlayerManager().getMaxClaimPermission(player))) {
            this.lm.sendMessage((CommandSender)player, this.plugin.getLangManager().getString("Shop.notAllowed"));
            return false;
        }
        return true;
    }
}

