/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.admin;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IPlayerManager;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.multi.MultiClearInactiveTask;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClearInactive
extends LandlordCommand {
    private final ILangManager lgManager;
    private final IPlayerManager playerManager;
    private final IMultiTaskManager multiTaskManager;

    public ClearInactive(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.ClearInactive.name"), plugin.getConfig().getString("CommandSettings.ClearInactive.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.ClearInactive.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.ClearInactive.aliases")));
        this.lgManager = plugin.getLangManager();
        this.playerManager = plugin.getPlayerManager();
        this.multiTaskManager = plugin.getMultiTaskManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (arguments.size() == 1) {
            try {
                int minInactiveDays = arguments.getInt(0);
                if (properties.getCommandSender().hasPermission("landlord.admin.clearinactive")) {
                    this.clearInactive(minInactiveDays, properties.getCommandSender());
                }
            }
            catch (NumberFormatException e) {
                properties.sendUsage();
            }
        } else {
            properties.sendUsage();
        }
    }

    private void clearInactive(final int minInactiveDays, final CommandSender sender) {
        this.lgManager.sendMessage(sender, this.lgManager.getString("Commands.ClearInactive.info").replace("%inactivity%", String.valueOf(minInactiveDays)));
        new BukkitRunnable(){

            public void run() {
                OfflinePlayer[] offlinePlayers = ClearInactive.this.plugin.getServer().getOfflinePlayers();
                ArrayList<OfflinePlayer> playersToClear = new ArrayList<OfflinePlayer>(offlinePlayers.length);
                for (OfflinePlayer offlinePlayer : offlinePlayers) {
                    boolean isInactive;
                    IPlayer lPlayer = ClearInactive.this.playerManager.getOfflineSync(offlinePlayer.getUniqueId());
                    if (lPlayer == null) continue;
                    Duration offlineInterval = Duration.between(lPlayer.getLastSeen(), LocalDateTime.now());
                    boolean bl = isInactive = offlineInterval.compareTo(Duration.ofDays(minInactiveDays)) > 0;
                    if (!isInactive) continue;
                    playersToClear.add(offlinePlayer);
                }
                ClearInactive.this.multiTaskManager.enqueueTask(new MultiClearInactiveTask(ClearInactive.this.plugin, sender, playersToClear, minInactiveDays));
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

