/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.admin;

import biz.princeps.landlord.api.ClearType;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.guis.ClearGUI;
import biz.princeps.landlord.multi.MultiClearTask;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Clear
extends LandlordCommand {
    private final IWorldGuardManager wg;
    private final IMultiTaskManager multiTaskManager;

    public Clear(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Clear.name"), plugin.getConfig().getString("CommandSettings.Clear.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Clear.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Clear.aliases")));
        this.wg = plugin.getWGManager();
        this.multiTaskManager = plugin.getMultiTaskManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (arguments.size() == 1) {
            String name = arguments.get(0);
            if (properties.getCommandSender().hasPermission("landlord.admin.clear.player")) {
                this.clearPlayer(name, properties.getCommandSender());
            }
            return;
        }
        if (properties.isConsole()) {
            return;
        }
        Player player = properties.getPlayer();
        ClearGUI clearGUI = new ClearGUI(this.plugin, player);
        clearGUI.display();
    }

    private void clearPlayer(String name, CommandSender player) {
        this.plugin.getPlayerManager().getOffline(name, lPlayer -> {
            if (lPlayer == null) {
                this.lm.sendMessage(player, this.lm.getString("Commands.Clear.noPlayer").replace("%players%", name));
            } else {
                this.multiTaskManager.enqueueTask(new MultiClearTask(this.plugin, player, this.wg.getRegions(lPlayer.getUuid()), lPlayer.getName(), ClearType.PLAYER));
            }
        });
    }
}

