/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.admin;

import LandLord.landlord.paperlib.PaperLib;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import biz.princeps.lib.gui.MultiPagedGUI;
import biz.princeps.lib.gui.simple.Icon;
import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdminTeleport
extends LandlordCommand {
    public AdminTeleport(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.AdminTP.name"), plugin.getConfig().getString("CommandSettings.AdminTP.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.AdminTP.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.AdminTP.aliases")));
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        String target;
        if (properties.isConsole()) {
            return;
        }
        Player sender = properties.getPlayer();
        try {
            target = arguments.get(0);
        }
        catch (ArgumentsOutOfBoundsException e) {
            properties.sendUsage();
            return;
        }
        this.plugin.getPlayerManager().getOffline(target, offline -> {
            if (offline == null) {
                this.lm.sendMessage((CommandSender)sender, this.lm.getString(sender, "Commands.AdminTp.noPlayer").replace("%player%", target));
            } else {
                Set<IOwnedLand> lands = this.plugin.getWGManager().getRegions(offline.getUuid());
                if (lands.size() > 0) {
                    MultiPagedGUI landGui = new MultiPagedGUI(this.plugin, sender, 5, this.lm.getRawString("Commands.AdminTp.guiHeader").replace("%player%", target));
                    for (IOwnedLand land : lands) {
                        landGui.addIcon(new Icon(new ItemStack(this.plugin.getMaterialsManager().getGrass())).setName(land.getName()).addClickAction(p -> {
                            Location toTp = land.getALocation();
                            PaperLib.teleportAsync((Entity)sender, toTp).thenRun(() -> land.highlightLand(sender, Particle.VILLAGER_HAPPY));
                        }));
                    }
                    landGui.display();
                } else {
                    this.lm.sendMessage((CommandSender)sender, this.lm.getString(sender, "Commands.AdminTp.noLands").replace("%player%", target));
                }
            }
        });
    }
}

