/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.admin.AdminClaim;
import biz.princeps.landlord.commands.admin.AdminTeleport;
import biz.princeps.landlord.commands.admin.Clear;
import biz.princeps.landlord.commands.admin.ClearInactive;
import biz.princeps.landlord.commands.admin.Debug;
import biz.princeps.landlord.commands.admin.GiveClaims;
import biz.princeps.landlord.commands.admin.Reload;
import biz.princeps.landlord.commands.admin.Update;
import biz.princeps.landlord.commands.claiming.Claim;
import biz.princeps.landlord.commands.claiming.Claims;
import biz.princeps.landlord.commands.claiming.MultiClaim;
import biz.princeps.landlord.commands.claiming.MultiUnclaim;
import biz.princeps.landlord.commands.claiming.Shop;
import biz.princeps.landlord.commands.claiming.Unclaim;
import biz.princeps.landlord.commands.claiming.UnclaimAll;
import biz.princeps.landlord.commands.claiming.adv.Advertise;
import biz.princeps.landlord.commands.claiming.adv.RemoveAdvertise;
import biz.princeps.landlord.commands.friends.Addfriend;
import biz.princeps.landlord.commands.friends.AddfriendAll;
import biz.princeps.landlord.commands.friends.ListFriends;
import biz.princeps.landlord.commands.friends.MultiAddfriend;
import biz.princeps.landlord.commands.friends.MultiRemovefriend;
import biz.princeps.landlord.commands.friends.Unfriend;
import biz.princeps.landlord.commands.friends.UnfriendAll;
import biz.princeps.landlord.commands.homes.Home;
import biz.princeps.landlord.commands.homes.SetHome;
import biz.princeps.landlord.commands.management.Info;
import biz.princeps.landlord.commands.management.LandMap;
import biz.princeps.landlord.commands.management.ListLands;
import biz.princeps.landlord.commands.management.Manage;
import biz.princeps.landlord.commands.management.ManageAll;
import biz.princeps.landlord.commands.management.MultiListLands;
import biz.princeps.landlord.commands.management.MultiManage;
import biz.princeps.landlord.commands.management.Regenerate;
import biz.princeps.landlord.commands.management.borders.Borders;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.chat.MultiPagedMessage;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.MainCommand;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.command.SubCommand;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Landlordbase
extends MainCommand {
    private final ILandLord plugin;

    public Landlordbase(ILandLord plugin) {
        super(plugin.getConfig().getString("CommandSettings.Main.name"), plugin.getConfig().getString("CommandSettings.Main.description"), plugin.getConfig().getString("CommandSettings.Main.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Main.permissions")), plugin.getConfig().getStringList("CommandSettings.Main.aliases").toArray(new String[0]));
        this.plugin = plugin;
        this.reloadCommands();
    }

    private void reloadCommands() {
        this.clearSubcommands();
        this.addSubcommand(new Version());
        this.addSubcommand(new Confirm());
        this.addSubcommand(new Info(this.plugin));
        this.addSubcommand(new Claim(this.plugin, false));
        this.addSubcommand(new Unclaim(this.plugin));
        this.addSubcommand(new UnclaimAll(this.plugin));
        this.addSubcommand(new Addfriend(this.plugin));
        this.addSubcommand(new AddfriendAll(this.plugin));
        this.addSubcommand(new Unfriend(this.plugin));
        this.addSubcommand(new UnfriendAll(this.plugin));
        this.addSubcommand(new Advertise(this.plugin));
        this.addSubcommand(new RemoveAdvertise(this.plugin));
        this.addSubcommand(new ListFriends(this.plugin));
        this.addSubcommand(new ListLands(this.plugin));
        this.addSubcommand(new Claims(this.plugin));
        this.addSubcommand(new Shop(this.plugin));
        this.addSubcommand(new GiveClaims(this.plugin));
        this.addSubcommand(new Update(this.plugin));
        this.addSubcommand(new AdminTeleport(this.plugin));
        this.addSubcommand(new AdminClaim(this.plugin));
        this.addSubcommand(new MultiClaim(this.plugin));
        this.addSubcommand(new Borders(this.plugin));
        this.addSubcommand(new Home(this.plugin));
        this.addSubcommand(new SetHome(this.plugin));
        this.addSubcommand(new Manage(this.plugin));
        this.addSubcommand(new ManageAll(this.plugin));
        this.addSubcommand(new Clear(this.plugin));
        this.addSubcommand(new ClearInactive(this.plugin));
        this.addSubcommand(new LandMap(this.plugin));
        this.addSubcommand(new Reload(this.plugin));
        this.addSubcommand(new Regenerate(this.plugin));
        this.addSubcommand(new MultiUnclaim(this.plugin));
        this.addSubcommand(new MultiAddfriend(this.plugin));
        this.addSubcommand(new MultiRemovefriend(this.plugin));
        this.addSubcommand(new MultiListLands(this.plugin));
        this.addSubcommand(new MultiManage(this.plugin));
        this.addSubcommand(new Debug(this.plugin));
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> tabReturn;
        block27: {
            block26: {
                tabReturn = new ArrayList<String>();
                if (args.length != 1) break block26;
                for (SubCommand subCommand : this.subCommandMap.values()) {
                    if (!subCommand.hasPermission(sender)) continue;
                    if (subCommand instanceof Borders) {
                        if (!Options.enabled_borders()) continue;
                        tabReturn.add(subCommand.getName());
                        continue;
                    }
                    if (subCommand instanceof LandMap) {
                        if (!Options.enabled_map()) continue;
                        tabReturn.add(subCommand.getName());
                        continue;
                    }
                    if (subCommand instanceof Shop || subCommand instanceof Claims || subCommand instanceof GiveClaims) {
                        if (!Options.enabled_shop()) continue;
                        tabReturn.add(subCommand.getName());
                        continue;
                    }
                    if (subCommand instanceof Home || subCommand instanceof SetHome) {
                        if (!Options.enabled_homes()) continue;
                        tabReturn.add(subCommand.getName());
                        continue;
                    }
                    tabReturn.add(subCommand.getName());
                }
                if (args[0].isEmpty()) break block27;
                tabReturn.removeIf(next -> !next.startsWith(args[0]));
                break block27;
            }
            if (args.length == 2) {
                for (SubCommand subCommand : this.subCommandMap.values()) {
                    if (!subCommand.matches(args[0])) continue;
                    if (subCommand instanceof GiveClaims) {
                        tabReturn.add("<amount>");
                        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                            tabReturn.add(onlinePlayer.getName());
                        }
                        return tabReturn;
                    }
                    if (subCommand instanceof AdminTeleport) {
                        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                            tabReturn.add(onlinePlayer.getName());
                        }
                        return tabReturn;
                    }
                    if (subCommand instanceof LandMap) {
                        tabReturn.add("on");
                        tabReturn.add("off");
                        return tabReturn;
                    }
                    if (subCommand instanceof Addfriend || subCommand instanceof AddfriendAll || subCommand instanceof Unfriend || subCommand instanceof UnfriendAll) {
                        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                            if (!onlinePlayer.getName().startsWith(args[1]) || sender instanceof Player && !((Player)sender).canSee(onlinePlayer)) continue;
                            tabReturn.add(onlinePlayer.getName());
                        }
                        return tabReturn;
                    }
                    if (subCommand instanceof MultiClaim || subCommand instanceof MultiUnclaim || subCommand instanceof MultiAddfriend || subCommand instanceof MultiRemovefriend || subCommand instanceof MultiListLands || subCommand instanceof MultiManage) {
                        for (MultiMode multiMode : MultiMode.values()) {
                            tabReturn.add(multiMode.name());
                        }
                        return tabReturn;
                    }
                    if (subCommand instanceof UnclaimAll) {
                        for (World world : this.plugin.getServer().getWorlds()) {
                            tabReturn.add(world.getName());
                        }
                        return tabReturn;
                    }
                    if (!(subCommand instanceof Update)) continue;
                    tabReturn.add("-u");
                    tabReturn.add("-r");
                    tabReturn.add("-c");
                    return tabReturn;
                }
            } else if (args.length == 3) {
                for (SubCommand subCommand : this.subCommandMap.values()) {
                    if (!subCommand.matches(args[0])) continue;
                    if (subCommand instanceof GiveClaims) {
                        tabReturn.add("<amount>");
                        tabReturn.add("<price>");
                        return tabReturn;
                    }
                    if (!(subCommand instanceof MultiAddfriend) && !(subCommand instanceof MultiRemovefriend)) continue;
                    for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                        if (!onlinePlayer.getName().startsWith(args[2]) || sender instanceof Player && !((Player)sender).canSee(onlinePlayer)) continue;
                        tabReturn.add(onlinePlayer.getName());
                    }
                    return tabReturn;
                }
            } else if (args.length == 4) {
                for (SubCommand subCommand : this.subCommandMap.values()) {
                    if (!subCommand.matches(args[0]) || !(subCommand instanceof GiveClaims)) continue;
                    tabReturn.add("<amount>");
                }
            }
        }
        return tabReturn;
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        ILangManager lm = this.plugin.getLangManager();
        List<String> playersList = lm.getStringList("Commands.Help.players");
        List<String> adminList = lm.getStringList("Commands.Help.admins");
        int perSite = this.plugin.getConfig().getInt("HelpCommandPerSite");
        String[] argsN = new String[1];
        if (arguments.get().length == 1) {
            argsN[0] = arguments.get(0) == null ? "0" : arguments.get(0);
        }
        ArrayList<String> toDisplay = new ArrayList<String>();
        if (properties.getPlayer().hasPermission("landlord.admin.help")) {
            toDisplay.addAll(adminList);
        }
        toDisplay.addAll(playersList);
        MultiPagedMessage msg = new MultiPagedMessage.Builder().setElements(toDisplay).setPerSite(perSite).setHeaderString(lm.getRawString("Commands.Help.header")).setNextString(lm.getRawString("Commands.Help.next")).setPreviousString(lm.getRawString("Commands.Help.previous")).setCommand(this.plugin.getConfig().getString("CommandSettings.Main.name"), argsN).build();
        this.plugin.getUtilsManager().sendBasecomponent(properties.getPlayer(), msg.create());
    }

    public class Version
    extends SubCommand {
        public Version() {
            super("version", "/ll version", Sets.newHashSet(Collections.singleton("landlord.admin")), Sets.newHashSet());
        }

        @Override
        public void onCommand(Properties properties, Arguments arguments) {
            String msg = Landlordbase.this.plugin.getLangManager().getTag() + " &aLandLord version: &7%version%".replace("%version%", Landlordbase.this.plugin.getDescription().getVersion());
            properties.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        }
    }

    public class Confirm
    extends SubCommand {
        public Confirm() {
            super("confirm", "/ll help", Sets.newHashSet(Collections.singleton("landlord.use")), Sets.newHashSet());
        }

        @Override
        public void onCommand(Properties properties, Arguments arguments) {
        }
    }
}

