/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.util.JavaUtils;
import biz.princeps.lib.command.SubCommand;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class LandlordCommand
extends SubCommand {
    protected final ILandLord plugin;
    protected final ILangManager lm;

    public LandlordCommand(ILandLord plugin, String name, String usage, Set<String> permissions, Set<String> aliases) {
        super(name, usage, permissions, aliases);
        this.plugin = plugin;
        this.lm = plugin.getLangManager();
    }

    public boolean isInsideWorld(Player player) {
        return this.isInsideWorld(player, player.getLocation());
    }

    public boolean isInsideWorld(Player player, Chunk chunk) {
        return this.isInsideWorld(player, new Location(chunk.getWorld(), (double)((chunk.getX() << 4) + 8), 100.0, (double)((chunk.getZ() << 4) + 8)));
    }

    public boolean isInsideWorld(Player player, Location location) {
        if (location.getWorld().getWorldBorder().isInside(location)) {
            return true;
        }
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "locOutsideWorld").replace("%chunk%", this.plugin.getWGManager().getLandName(location)).replace("%world%", location.getWorld().getName()));
        return false;
    }

    public boolean isDisabledWorld(Player player) {
        return JavaUtils.isDisabledWorld(this.lm, this.plugin, player, player.getWorld(), true);
    }

    public boolean isDisabledWorld(Player player, World world) {
        return JavaUtils.isDisabledWorld(this.lm, this.plugin, player, world, true);
    }

    public boolean isDisabledWorld(World world) {
        return JavaUtils.isDisabledWorld(this.lm, this.plugin, null, world, false);
    }
}

