/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public enum ClaimHeightDefinition {
    AVERAGE(list -> {
        int sum = 0;
        for (Integer val : list) {
            sum += val.intValue();
        }
        return sum / list.size();
    }),
    FIXED(list -> 0),
    FULL(list -> 0),
    HIGHEST(list -> {
        int highest = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int integer = (Integer)iterator.next();
            highest = Math.max(highest, integer);
        }
        return highest;
    }),
    LOWEST(list -> {
        int lowest = Integer.MAX_VALUE;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int integer = (Integer)iterator.next();
            lowest = Math.min(lowest, integer);
        }
        return lowest;
    }),
    MEDIAN(list -> {
        Collections.sort(list);
        return ((Integer)list.get(list.size() / 2) + (Integer)list.get(list.size() / 2 + 1)) / 2;
    });

    private final Function<List<Integer>, Integer> calc;

    private ClaimHeightDefinition(Function<List<Integer>, Integer> calc) {
        this.calc = calc;
    }

    public int getCenter(List<Integer> points) {
        return this.calc.apply(points);
    }

    public static ClaimHeightDefinition parse(String value) {
        for (ClaimHeightDefinition def : ClaimHeightDefinition.values()) {
            if (!def.name().equalsIgnoreCase(value)) continue;
            return def;
        }
        return null;
    }
}

