/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.api;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTask;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

public abstract class AMultiTask<T>
implements IMultiTask<T> {
    protected final ILandLord plugin;
    protected final Deque<T> queue;

    public AMultiTask(ILandLord plugin, Collection<T> operations) {
        this.plugin = plugin;
        this.queue = new ArrayDeque<T>(operations);
    }

    @Override
    public int processOperations(int limit) {
        int iterations = 0;
        while (iterations < limit && !this.queue.isEmpty()) {
            T value = this.queue.remove();
            boolean success = this.process(value);
            if (!success) continue;
            ++iterations;
        }
        return iterations;
    }

    @Override
    public void complete() {
    }

    @Override
    public boolean isCompleted() {
        return this.queue.isEmpty();
    }

    @Override
    public int clearQueue() {
        int remainingOperations = this.queue.size();
        this.queue.clear();
        return remainingOperations;
    }
}

