/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord;

import biz.princeps.landlord.LLFlag;
import biz.princeps.landlord.api.ILLFlag;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMob;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.manager.WorldGuardManager;
import biz.princeps.landlord.protection.AOwnedLand;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class OwnedLand
extends AOwnedLand {
    private final ProtectedRegion region;
    private final FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();

    public static OwnedLand create(ILandLord plugin, ProtectedRegion pr, UUID owner) {
        return new OwnedLand(plugin, pr, owner);
    }

    public static OwnedLand of(ILandLord plugin, ProtectedRegion pr) {
        return new OwnedLand(plugin, pr);
    }

    private OwnedLand(ILandLord plugin, ProtectedRegion region) {
        super(plugin, plugin.getWGManager().getWorld(region.getId()), region.getId());
        this.region = region;
    }

    private OwnedLand(ILandLord plugin, ProtectedRegion region, UUID owner) {
        this(plugin, region);
        if (region.getFlags().size() == 0) {
            this.initFlags(owner);
            this.initRegionPriority();
        }
    }

    @Override
    public int getMaxY() {
        return this.region.getMaximumPoint().getY();
    }

    @Override
    public int getMinY() {
        return this.region.getMinimumPoint().getY();
    }

    @Override
    public String getOwnersString() {
        return this.formatNames(this.region.getOwners().getUniqueIds());
    }

    @Override
    public String getMembersString() {
        return this.formatNames(this.region.getMembers().getUniqueIds());
    }

    @Override
    public boolean isOwner(UUID uuid) {
        return this.region.getOwners().contains(uuid);
    }

    @Override
    public UUID getOwner() {
        Set uniqueIds = this.region.getOwners().getUniqueIds();
        if (uniqueIds.size() != 1) {
            this.plugin.getLogger().warning("The region " + this.getName() + " is faulty! It does not have an owner!");
            return null;
        }
        return (UUID)uniqueIds.iterator().next();
    }

    @Override
    public void replaceOwner(UUID uuid) {
        this.region.getOwners().clear();
        this.region.getOwners().addPlayer(uuid);
    }

    @Override
    public boolean isFriend(UUID uuid) {
        return this.region.getMembers().contains(uuid);
    }

    @Override
    public Set<UUID> getFriends() {
        return this.region.getMembers().getUniqueIds();
    }

    @Override
    public void addFriend(UUID uuid) {
        this.region.getMembers().addPlayer(uuid);
    }

    @Override
    public void removeFriend(UUID uuid) {
        this.region.getMembers().removePlayer(uuid);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.region.contains(x, y, z);
    }

    public String toString() {
        return "OwnedLand{chunk=" + this.name + '}';
    }

    @Override
    public List<ILLFlag> getFlags() {
        ArrayList<ILLFlag> toReturn = new ArrayList<ILLFlag>();
        List rawList = this.plugin.getConfig().getStringList("Flags");
        for (String s : rawList) {
            toReturn.add(this.getFlag(s));
        }
        return toReturn;
    }

    @Override
    public ILLFlag getFlag(String s) {
        Flag<StateFlag.State> flag = this.getWGFlag(s.toLowerCase());
        if (flag == null) {
            this.plugin.getLogger().warning("Invalid worldguard flag found: " + s);
        }
        Material mat = Material.valueOf((String)this.plugin.getConfig().getString("Manage." + s.toLowerCase() + ".item"));
        return new LLFlag(this.region, flag, mat);
    }

    @Override
    public String getGreetMessage() {
        String greetMessage = (String)this.region.getFlag((Flag)Flags.GREET_MESSAGE);
        return greetMessage == null ? "" : greetMessage;
    }

    @Override
    public void setGreetMessage(String newmsg) {
        this.region.setFlag((Flag)Flags.GREET_MESSAGE, (Object)newmsg);
    }

    @Override
    public String getFarewellMessage() {
        String farewellMessage = (String)this.region.getFlag((Flag)Flags.FAREWELL_MESSAGE);
        return farewellMessage == null ? "" : farewellMessage;
    }

    @Override
    public void setFarewellMessage(String newmsg) {
        this.region.setFlag((Flag)Flags.FAREWELL_MESSAGE, (Object)newmsg);
    }

    @Override
    public void toggleMob(IMob mob) {
        Set flag = (Set)this.region.getFlag((Flag)Flags.DENY_SPAWN);
        if (flag == null) {
            HashSet entityTypes = Sets.newHashSet((Object[])new EntityType[]{(EntityType)EntityType.REGISTRY.get(mob.getName().toLowerCase())});
            this.region.setFlag((Flag)Flags.DENY_SPAWN, (Object)entityTypes);
            return;
        }
        if (flag.contains(EntityType.REGISTRY.get(mob.getName().toLowerCase()))) {
            flag.remove(EntityType.REGISTRY.get(mob.getName().toLowerCase()));
        } else {
            flag.add((EntityType)EntityType.REGISTRY.get(mob.getName().toLowerCase()));
        }
    }

    @Override
    public boolean isMobDenied(IMob mob) {
        Set flag = (Set)this.region.getFlag((Flag)Flags.DENY_SPAWN);
        if (flag == null) {
            return false;
        }
        return flag.contains(EntityType.REGISTRY.get(mob.getName().toLowerCase()));
    }

    @Override
    public double getPrice() {
        Double flag = (Double)this.region.getFlag((Flag)WorldGuardManager.REGION_PRICE_FLAG);
        if (flag == null) {
            return -1.0;
        }
        return flag;
    }

    @Override
    public void setPrice(double price) {
        this.region.setFlag((Flag)WorldGuardManager.REGION_PRICE_FLAG, (Object)price);
    }

    @Override
    public void initFlags(UUID owner) {
        List rawList = this.plugin.getConfig().getStringList("Flags");
        for (String s : rawList) {
            ILLFlag flag1;
            Flag<StateFlag.State> flag = this.getWGFlag(s.toUpperCase());
            if (!(flag instanceof StateFlag)) {
                this.plugin.getLogger().warning("Only stateflags are supported!");
                return;
            }
            this.region.setFlag((Flag)flag.getRegionGroupFlag(), (Object)RegionGroup.MEMBERS);
            this.region.setFlag(flag, (Object)StateFlag.State.ALLOW);
            if (!this.plugin.getConfig().getBoolean("Manage." + s + ".default.friends", true)) {
                flag1 = this.getFlag(s);
                flag1.toggleFriends();
            }
            if (!this.plugin.getConfig().getBoolean("Manage." + s + ".default.everyone", false)) continue;
            flag1 = this.getFlag(s);
            flag1.toggleAll();
        }
        OfflinePlayer p = this.plugin.getServer().getOfflinePlayer(owner);
        if (p.getName() == null) {
            return;
        }
        this.region.setFlag((Flag)Flags.GREET_MESSAGE, (Object)this.plugin.getLangManager().getRawString("Alerts.defaultGreeting").replace("%owner%", p.getName()));
        this.region.setFlag((Flag)Flags.FAREWELL_MESSAGE, (Object)this.plugin.getLangManager().getRawString("Alerts.defaultFarewell").replace("%owner%", p.getName()));
    }

    @Override
    public void updateFlags(UUID owner) {
        List rawList = this.plugin.getConfig().getStringList("Flags");
        for (Flag iWrapperFlag : this.region.getFlags().keySet()) {
            String flagname = iWrapperFlag.getName().toLowerCase().replace("-group", "");
            if (rawList.contains(flagname) || flagname.equals(Flags.GREET_MESSAGE.getName().toLowerCase()) || flagname.equals(Flags.FAREWELL_MESSAGE.getName().toLowerCase())) continue;
            this.region.setFlag(iWrapperFlag, null);
        }
        for (String s : rawList) {
            ILLFlag flag1;
            Flag<StateFlag.State> flag = this.getWGFlag(s.toLowerCase());
            if (this.region.getFlags().containsKey(flag)) continue;
            this.region.setFlag((Flag)flag.getRegionGroupFlag(), (Object)RegionGroup.MEMBERS);
            this.region.setFlag(flag, (Object)StateFlag.State.ALLOW);
            if (!this.plugin.getConfig().getBoolean("Manage." + s + ".default.friends", true)) {
                flag1 = this.getFlag(s);
                flag1.toggleFriends();
            }
            if (!this.plugin.getConfig().getBoolean("Manage." + s + ".default.everyone", false)) continue;
            flag1 = this.getFlag(s);
            flag1.toggleAll();
        }
        OfflinePlayer p = this.plugin.getServer().getOfflinePlayer(owner);
        if (p.getName() == null) {
            return;
        }
        if (!this.region.getFlags().containsKey(Flags.GREET_MESSAGE)) {
            this.region.setFlag((Flag)Flags.GREET_MESSAGE, (Object)this.plugin.getLangManager().getRawString("Alerts.defaultGreeting").replace("%owner%", p.getName()));
        } else if (!this.region.getFlags().containsKey(Flags.FAREWELL_MESSAGE)) {
            this.region.setFlag((Flag)Flags.FAREWELL_MESSAGE, (Object)this.plugin.getLangManager().getRawString("Alerts.defaultFarewell").replace("%owner%", p.getName()));
        }
    }

    @Override
    public void reclaim() {
        IWorldGuardManager wg = this.plugin.getWGManager();
        UUID owner = this.getOwner();
        OwnedLand ownedLand = (OwnedLand)wg.claim(this.getChunk(), owner);
        ownedLand.getRegion().copyFrom(this.region);
    }

    @Override
    public void initRegionPriority() {
        this.region.setPriority(this.plugin.getConfig().getInt("Claim.regionPriority"));
    }

    private ProtectedRegion getRegion() {
        return this.region;
    }

    private Flag<StateFlag.State> getWGFlag(String flagName) {
        return Flags.fuzzyMatchFlag((FlagRegistry)this.flagRegistry, (String)flagName);
    }
}

