/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.LandChangeEvent;
import biz.princeps.landlord.manager.WorldGuardManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FarewellFlag;
import com.sk89q.worldguard.session.handler.GreetingFlag;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Set;
import org.bukkit.event.Event;

public class LandSessionHandler
extends Handler {
    private final ILandLord plugin;
    private final IWorldGuardManager worldGuardManager;
    private final GreetingFlag greeting;
    private final FarewellFlag farewell;

    private LandSessionHandler(ILandLord plugin, Session session, IWorldGuardManager worldGuardManager) {
        super(session);
        this.plugin = plugin;
        this.worldGuardManager = worldGuardManager;
        this.greeting = GreetingFlag.FACTORY.create(session);
        this.farewell = FarewellFlag.FACTORY.create(session);
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        if (entered.isEmpty() && exited.isEmpty()) {
            return true;
        }
        IOwnedLand enteredLand = this.getFirstOwnedLand(entered);
        IOwnedLand exitedLand = this.getFirstOwnedLand(exited);
        if (enteredLand == null && exitedLand == null) {
            return this.greeting.onCrossBoundary(player, from, to, toSet, entered, exited, moveType) && this.farewell.onCrossBoundary(player, from, to, toSet, entered, exited, moveType);
        }
        if (enteredLand != null && exitedLand != null && enteredLand.getOwner().equals(exitedLand.getOwner())) {
            return true;
        }
        if (enteredLand == null && !entered.isEmpty()) {
            this.greeting.onCrossBoundary(player, from, to, toSet, entered, exited, moveType);
        }
        if (exitedLand == null && !exited.isEmpty()) {
            this.farewell.onCrossBoundary(player, from, to, toSet, entered, exited, moveType);
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new LandChangeEvent(BukkitAdapter.adapt((Player)player), exitedLand, enteredLand));
        return true;
    }

    private IOwnedLand getFirstOwnedLand(Set<ProtectedRegion> regions) {
        for (ProtectedRegion region : regions) {
            IOwnedLand land = this.worldGuardManager.getRegion(region.getId());
            if (land == null) continue;
            return land;
        }
        return null;
    }

    public static final class Factory
    extends Handler.Factory<LandSessionHandler> {
        private final ILandLord plugin;
        private final WorldGuardManager worldGuardManager;

        public Factory(ILandLord plugin, WorldGuardManager worldGuardManager) {
            this.plugin = plugin;
            this.worldGuardManager = worldGuardManager;
        }

        public LandSessionHandler create(Session session) {
            return new LandSessionHandler(this.plugin, session, this.worldGuardManager);
        }
    }
}

