/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord;

import biz.princeps.landlord.ALandLord;
import biz.princeps.landlord.LandSessionHandler;
import biz.princeps.landlord.listener.PistonOverwriter;
import biz.princeps.landlord.listener.WGRegenListener;
import biz.princeps.landlord.manager.MaterialsManager;
import biz.princeps.landlord.manager.MobsManager;
import biz.princeps.landlord.manager.UtilsManager;
import biz.princeps.landlord.manager.WorldGuardManager;
import biz.princeps.landlord.regenerators.RegenerationManager;
import biz.princeps.landlord.regenerators.WGRegenerator;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.FarewellFlag;
import com.sk89q.worldguard.session.handler.GreetingFlag;
import com.sk89q.worldguard.session.handler.Handler;
import java.io.File;
import org.bukkit.plugin.Plugin;

public class LandLord
extends ALandLord {
    @Override
    public void onLoad() {
        WorldGuardManager.initFlags();
        super.onLoad();
    }

    @Override
    public void onEnable() {
        if (!this.checkDependencies()) {
            return;
        }
        this.worldGuardManager = new WorldGuardManager(this, this.getWorldGuard());
        this.utilsManager = new UtilsManager();
        this.materialsManager = new MaterialsManager(this);
        this.mobManager = new MobsManager(this);
        if (this.getConfig().getString("Regeneration.provider", "default").equalsIgnoreCase("wg")) {
            File folder = new File(this.getDataFolder(), "chunksaves");
            folder.mkdir();
            this.regenerationManager = new WGRegenerator(this);
            new WGRegenListener(this);
        } else {
            this.regenerationManager = new RegenerationManager();
        }
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        sessionManager.registerHandler((Handler.Factory)new LandSessionHandler.Factory(this, (WorldGuardManager)this.worldGuardManager), null);
        sessionManager.unregisterHandler((Handler.Factory)GreetingFlag.FACTORY);
        sessionManager.unregisterHandler((Handler.Factory)FarewellFlag.FACTORY);
        ((WorldGuardManager)this.worldGuardManager).initCache();
        super.onEnable();
        new PistonOverwriter(this);
        int currentDataVersion = this.getServer().getUnsafe().getDataVersion();
        if (currentDataVersion > 2858 && this.getConfig().getBoolean("check-1-18-world-heights")) {
            this.getLogger().warning("It appears that Landlord is not fully ready to run Minecraft 1.18+. Due to world height changes, Landlord lands must be converted. Check and adjust your configuration and convert your lands if necessary. This operation could be unsuccessful, so don't hesitate to BACKUP configuration/regions, contact us and use the command '/ll update -c'!");
            this.getLogger().info("To disable this warning once all notes considered, set 'check-1-18-world-heights' to false.");
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    @Override
    protected boolean checkDependencies() {
        if (!super.checkDependencies()) {
            return false;
        }
        String version = this.getServer().getVersion();
        if (!(version.contains("1.13.2") || version.contains("1.14") || version.contains("1.15") || version.contains("1.16") || version.contains("1.17") || version.contains("1.18") || version.contains("1.19"))) {
            this.haltPlugin("Invalid Spigot version detected! LandLord latest requires 1.13.2/1.14.x/1.15.x/1.16.x/1.17.x/1.18.x/1.19.x, use Legacy version for 1.12.2!");
            return false;
        }
        if (this.getWorldGuard() == null) {
            this.haltPlugin("WorldGuard not found! Please ensure you have the correct version of WorldGuard in order to use LandLord. Maybe adequate WorldEdit plugin missing?");
            return false;
        }
        String worldGuardVersion = this.getWorldGuard().getDescription().getVersion();
        if (worldGuardVersion.charAt(0) < '7') {
            this.haltPlugin("Invalid WorldGuard Version found. LandLord requires WG 7.0.0+ ! You have WG " + worldGuardVersion);
            return false;
        }
        return true;
    }

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (!(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }
}

