/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord;

import biz.princeps.landlord.api.ILLFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Material;

public class LLFlag
implements ILLFlag {
    private final ProtectedRegion pr;
    private boolean friendStatus;
    private boolean allStatus;
    private final Flag<StateFlag.State> flag;
    private final Material mat;

    public LLFlag(ProtectedRegion pr, Flag<StateFlag.State> flag, Material mat) {
        this.pr = pr;
        this.flag = flag;
        this.mat = mat;
        RegionGroup regionGroupFlag = (RegionGroup)pr.getFlags().get(flag.getRegionGroupFlag());
        StateFlag.State value = (StateFlag.State)pr.getFlags().get(flag);
        this.setStatus(regionGroupFlag, value);
    }

    void setStatus(RegionGroup grp, Object state) {
        if (grp == RegionGroup.MEMBERS && state == StateFlag.State.ALLOW || grp == RegionGroup.NON_MEMBERS && state == StateFlag.State.DENY) {
            this.friendStatus = true;
            this.allStatus = false;
        }
        if (grp == RegionGroup.ALL && state == StateFlag.State.ALLOW) {
            this.friendStatus = true;
            this.allStatus = true;
        }
        if (grp == RegionGroup.NON_OWNERS && state == StateFlag.State.DENY) {
            this.friendStatus = false;
            this.allStatus = false;
        }
    }

    @Override
    public String getName() {
        return this.flag.getName();
    }

    @Override
    public boolean toggleFriends() {
        if (this.friendStatus) {
            this.friendStatus = false;
            if (this.allStatus) {
                return false;
            }
            this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.NON_OWNERS);
            this.pr.setFlag(this.flag, (Object)StateFlag.State.DENY);
            return true;
        }
        if (this.allStatus) {
            this.friendStatus = true;
            this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.ALL);
            this.pr.setFlag(this.flag, (Object)StateFlag.State.ALLOW);
        } else {
            this.friendStatus = true;
            if (this.flag.getRegionGroupFlag().getDefault() != RegionGroup.NON_MEMBERS) {
                this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.MEMBERS);
                this.pr.setFlag(this.flag, (Object)StateFlag.State.ALLOW);
            } else {
                this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.NON_MEMBERS);
                this.pr.setFlag(this.flag, (Object)StateFlag.State.DENY);
            }
        }
        return true;
    }

    @Override
    public boolean toggleAll() {
        if (this.allStatus) {
            this.allStatus = false;
            if (this.friendStatus) {
                if (this.flag.getRegionGroupFlag().getDefault() != RegionGroup.NON_MEMBERS) {
                    this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.MEMBERS);
                    this.pr.setFlag(this.flag, (Object)StateFlag.State.ALLOW);
                } else {
                    this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.NON_MEMBERS);
                    this.pr.setFlag(this.flag, (Object)StateFlag.State.DENY);
                }
            } else {
                this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.NON_OWNERS);
                this.pr.setFlag(this.flag, (Object)StateFlag.State.DENY);
            }
            return true;
        }
        if (this.friendStatus) {
            this.allStatus = true;
            this.pr.setFlag((Flag)this.flag.getRegionGroupFlag(), (Object)RegionGroup.ALL);
            this.pr.setFlag(this.flag, (Object)StateFlag.State.ALLOW);
            return true;
        }
        return false;
    }

    @Override
    public Material getMaterial() {
        return this.mat;
    }

    @Override
    public boolean getFriendStatus() {
        return this.friendStatus;
    }

    @Override
    public boolean getAllStatus() {
        return this.allStatus;
    }
}

