/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord;

import LandLord.landlord.eldoutilities.bstats.EldoMetrics;
import LandLord.landlord.eldoutilities.core.EldoUtilities;
import biz.princeps.landlord.api.IConfigurationManager;
import biz.princeps.landlord.api.ICostManager;
import biz.princeps.landlord.api.IDelimitationManager;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IMapManager;
import biz.princeps.landlord.api.IMaterialsManager;
import biz.princeps.landlord.api.IMobManager;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IPlayerManager;
import biz.princeps.landlord.api.IRegenerationManager;
import biz.princeps.landlord.api.IUtilsManager;
import biz.princeps.landlord.api.IVaultManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.integrations.LLLuckPerms;
import biz.princeps.landlord.integrations.Towny;
import biz.princeps.landlord.listener.JoinListener;
import biz.princeps.landlord.listener.LandChangeListener;
import biz.princeps.landlord.listener.MapListener;
import biz.princeps.landlord.listener.SecureWorldListener;
import biz.princeps.landlord.manager.ConfigurationManager;
import biz.princeps.landlord.manager.DelimitationManager;
import biz.princeps.landlord.manager.LPlayerManager;
import biz.princeps.landlord.manager.LangManager;
import biz.princeps.landlord.manager.VaultManager;
import biz.princeps.landlord.manager.cost.LandCostManager;
import biz.princeps.landlord.manager.map.MapManager;
import biz.princeps.landlord.multi.MultiTaskManager;
import biz.princeps.landlord.persistent.LPlayer;
import biz.princeps.landlord.placeholderapi.LLExpansion;
import biz.princeps.landlord.placeholderapi.LLFeatherBoard;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.manager.ConfirmationManager;
import java.util.regex.Pattern;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class ALandLord
extends JavaPlugin
implements ILandLord,
Listener {
    protected IWorldGuardManager worldGuardManager;
    protected IUtilsManager utilsManager;
    protected IMaterialsManager materialsManager;
    protected IVaultManager vaultManager;
    protected ILangManager langManager;
    protected IPlayerManager lPlayerManager;
    protected IMapManager mapManager;
    protected ICostManager costManager;
    protected IDelimitationManager delimitationManager;
    protected IMobManager mobManager;
    protected IRegenerationManager regenerationManager;
    protected IMultiTaskManager multiTaskManager;
    protected IConfigurationManager configurationManager;

    public void onLoad() {
        EldoUtilities.preWarm(this);
    }

    public void onEnable() {
        EldoUtilities.ignite(this);
        Options.setConfig(this.getConfig(), this.getVault() != null);
        this.setupPrincepsLib();
        this.checkWorldNames();
        this.setupConfig();
        this.setupIntegrations();
        this.setupItems();
        this.setupManagers();
        this.setupListeners();
        this.setupPlayers();
        this.setupMultiTaskManager();
        this.setupMetrics();
        this.postloadPrincepsLib();
    }

    public void onDisable() {
        EldoUtilities.shutdown();
        this.getLogger().info("Cancelling remaining tasks...");
        int clearedTasks = this.multiTaskManager.clear();
        this.getLogger().info(clearedTasks + " tasks have been cancelled!");
        this.getLogger().info("Clearing all maps...");
        if (this.mapManager != null) {
            this.mapManager.removeAllMaps();
        }
        this.getLogger().info("All maps have been cleared!");
        this.getLogger().info("Saving player data...");
        if (this.lPlayerManager != null) {
            this.getPlayerManager().saveAllOnlineSync();
        }
        this.getLogger().info("Player data has been saved!");
    }

    protected boolean checkDependencies() {
        if (this.getVault() == null) {
            this.getLogger().info("Vault or an economy provider could no be found. Not all features of landlord are working.");
        }
        return true;
    }

    protected void haltPlugin(String warning) {
        this.getLogger().warning(warning);
        this.getPluginLoader().disablePlugin((Plugin)this);
    }

    @Override
    @Deprecated
    public JavaPlugin getPlugin() {
        return this;
    }

    private void setupConfig() {
        this.configurationManager = new ConfigurationManager(this);
        this.saveDefaultConfig();
        this.configurationManager.handleConfigUpdate(this.getDataFolder() + "/config.yml", "/config.yml");
        this.saveDefaultConfig();
    }

    @Override
    public void setupPrincepsLib() {
        PrincepsLib.setPluginInstance(this);
        PrincepsLib.getConfirmationManager().setState(ConfirmationManager.STATE.valueOf(this.getConfig().getString("ConfirmationDialog.mode")));
        PrincepsLib.getConfirmationManager().setTimout(this.getConfig().getInt("ConfirmationDialog.timeout"));
    }

    @Override
    public void postloadPrincepsLib() {
        PrincepsLib.getTranslateableStrings().setString("Confirmation.accept", this.langManager.getRawString("Confirmation.accept"));
        PrincepsLib.getTranslateableStrings().setString("Confirmation.decline", this.langManager.getRawString("Confirmation.decline"));
        PrincepsLib.getTranslateableStrings().setString("noPermissionsCmd", this.langManager.getRawString("noPermissionsCmd"));
        PrincepsLib.getCommandManager().registerCommand(new Landlordbase(this));
    }

    private void setupPlayers() {
        for (Player onlinePlayer : this.getServer().getOnlinePlayers()) {
            this.getPlayerManager().getOffline(onlinePlayer.getUniqueId(), offline -> {
                if (offline == null) {
                    this.getPlayerManager().add(new LPlayer(onlinePlayer.getUniqueId()));
                } else {
                    this.getPlayerManager().add((IPlayer)offline);
                }
            });
        }
    }

    private void setupManagers() {
        this.langManager = new LangManager(this, this.getConfig().getString("language", "en"));
        this.lPlayerManager = new LPlayerManager(this);
        this.mapManager = new MapManager(this);
        this.costManager = new LandCostManager(this);
        this.vaultManager = new VaultManager(this, this.getVault());
        this.delimitationManager = new DelimitationManager(this);
    }

    private void checkWorldNames() {
        if (!this.getConfig().getBoolean("DisableStartupWorldWarning")) {
            Pattern pattern = Pattern.compile("[^A-Za-z0-9_-]+");
            for (World world : this.getServer().getWorlds()) {
                if (!pattern.matcher(world.getName()).find()) continue;
                this.getLogger().warning("Found an invalid world name (" + world.getName() + ")! LandLord will not work in this world!");
            }
        }
    }

    private void setupItems() {
    }

    private void setupIntegrations() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new LLExpansion(this).register();
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MVdWPlaceholderAPI")) {
            new LLFeatherBoard(this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Towny")) {
            new Towny(this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("LuckPerms")) {
            new LLLuckPerms(this);
        }
    }

    private void setupListeners() {
        new JoinListener(this);
        new MapListener(this);
        new LandChangeListener(this);
        if (this.getConfig().getBoolean("SecureWorld.enable")) {
            new SecureWorldListener(this);
        }
    }

    private void setupMultiTaskManager() {
        this.multiTaskManager = new MultiTaskManager(this);
        this.multiTaskManager.initTask();
    }

    private void setupMetrics() {
        EldoMetrics metrics = new EldoMetrics(this, 2322);
        if (metrics.isEnabled()) {
            this.getLogger().info("\u00a72Metrics enabled. Thank you :3");
        }
    }

    private Economy getVault() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (plugin == null) {
            return null;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        return rsp == null ? null : (Economy)rsp.getProvider();
    }

    @Override
    public IWorldGuardManager getWGManager() {
        return this.worldGuardManager;
    }

    @Override
    public IMaterialsManager getMaterialsManager() {
        return this.materialsManager;
    }

    @Override
    public IUtilsManager getUtilsManager() {
        return this.utilsManager;
    }

    @Override
    public IPlayerManager getPlayerManager() {
        return this.lPlayerManager;
    }

    @Override
    public ICostManager getCostManager() {
        return this.costManager;
    }

    @Override
    public IMapManager getMapManager() {
        return this.mapManager;
    }

    @Override
    public ILangManager getLangManager() {
        return this.langManager;
    }

    @Override
    public IVaultManager getVaultManager() {
        return this.vaultManager;
    }

    @Override
    public IDelimitationManager getDelimitationManager() {
        return this.delimitationManager;
    }

    @Override
    public IMobManager getMobManager() {
        return this.mobManager;
    }

    @Override
    public IRegenerationManager getRegenerationManager() {
        return this.regenerationManager;
    }

    @Override
    public IMultiTaskManager getMultiTaskManager() {
        return this.multiTaskManager;
    }

    @Override
    public IConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }
}

