/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjUtil {
    private ObjUtil() {
    }

    public static <T> boolean nonNull(@Nullable T obj, Consumer<T> execute) {
        if (obj == null) {
            return false;
        }
        execute.accept(obj);
        return true;
    }

    public static <T> boolean nonNull(@Nullable T obj, Consumer<T> execute, Runnable runnable) {
        if (obj == null) {
            runnable.run();
            return false;
        }
        execute.accept(obj);
        return true;
    }

    public static <T, U> U nonNull(@Nullable T obj, Function<T, U> execute) {
        if (obj == null) {
            return null;
        }
        return execute.apply(obj);
    }

    public static <T> T nonNull(@Nullable T obj, @NotNull T otherObject) {
        return obj == null ? otherObject : obj;
    }

    public static <R, A> R nonNullOrElse(@Nullable A obj, Function<A, R> function, R defaultVal) {
        if (obj != null) {
            return function.apply(obj);
        }
        return defaultVal;
    }
}

