/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagContainer {
    private static final Pattern FLAG = Pattern.compile("-([a-zA-Z]+?)");
    private static final Pattern NAMED_FLAG = Pattern.compile("--([a-zA-Z-])+?");
    private final Map<String, String> flags = new HashMap<String, String>();
    private final List<String> flagArgs = new LinkedList<String>();
    private final String[] args;
    private String currFlag = null;

    private FlagContainer(String[] args) {
        this.args = args;
    }

    public static FlagContainer of(String[] args) {
        FlagContainer flagContainer = new FlagContainer(args);
        flagContainer.parse();
        return flagContainer;
    }

    private void parse() {
        for (String arg : this.args) {
            if (FLAG.matcher(arg).matches()) {
                this.flushFlag();
                String flag = arg.substring(1);
                if (flag.length() > 1) {
                    this.addSingleFlags(flag);
                    continue;
                }
                this.currFlag = flag;
                continue;
            }
            if (NAMED_FLAG.matcher(arg).matches()) {
                this.flushFlag();
                this.currFlag = arg.substring(2);
                continue;
            }
            if (this.currFlag == null) continue;
            this.flagArgs.add(arg);
        }
        this.flushFlag();
    }

    private void flushFlag() {
        if (this.currFlag != null) {
            this.flags.put(this.currFlag, this.flagArgs.isEmpty() ? null : String.join((CharSequence)" ", this.flagArgs));
            this.flagArgs.clear();
            this.currFlag = null;
        }
    }

    private void addSingleFlags(String flags) {
        for (char c : flags.toCharArray()) {
            this.flags.put(String.valueOf(c), null);
        }
    }

    public boolean has(@NotNull String flag) {
        return this.flags.containsKey(flag);
    }

    public boolean hasValue(String flag) {
        return this.flags.get(flag) != null;
    }

    public <T> T get(@NotNull String flag, Function<@Nullable String, T> map) {
        return map.apply(this.get(flag));
    }

    @Nullable
    public String get(String flag) {
        return this.flags.get(flag);
    }

    public Optional<String> getIfPresent(String flag) {
        return Optional.ofNullable(this.get(flag));
    }

    public <T> Optional<T> getIfPresent(@NotNull String flag, Function<String, T> map) {
        return this.getIfPresent(flag).map(map);
    }
}

