/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.utils;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class EnumUtil {
    private EnumUtil() {
        throw new UnsupportedOperationException("This is a utility class!");
    }

    public static <T extends Enum<T>> Optional<T> parse(String value, Class<T> values) {
        return EnumUtil.parse(value, values, false);
    }

    public static <T extends Enum<T>> T parse(String value, Class<T> values, boolean stripStrings, T defaultValue) {
        return (T)((Enum)EnumUtil.parse(value, values, stripStrings).orElse(defaultValue));
    }

    public static <T extends Enum<T>> T parse(String value, Class<T> values, T defaultValue) {
        return (T)((Enum)EnumUtil.parse(value, values, false).orElse(defaultValue));
    }

    public static <T extends Enum<T>> Optional<T> parse(String mat, Class<T> values, boolean stripStrings) {
        for (Enum value : (Enum[])values.getEnumConstants()) {
            if (!mat.equalsIgnoreCase(stripStrings ? value.name().replace("_", "") : value.name())) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> String enumValues(Class<T> clazz) {
        return EnumUtil.enumValues(clazz, ", ");
    }

    public static <T extends Enum<T>> String enumValues(Class<T> clazz, String delimiter) {
        return Arrays.stream(clazz.getEnumConstants()).map(e -> e.name().toLowerCase()).collect(Collectors.joining(delimiter));
    }
}

