/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.utils;

import LandLord.landlord.eldoutilities.container.Pair;

public final class EMath {
    private EMath() {
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float min, float max, float value) {
        return Math.min(max, Math.max(value, min));
    }

    public static long clamp(long min, long max, long value) {
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float diff(float a, float b) {
        if (a <= 0.0f && b <= 0.0f || a > 0.0f && b > 0.0f) {
            Pair<Float, Float> values = EMath.compareValues(Math.abs(a), Math.abs(b));
            return ((Float)values.second).floatValue() - ((Float)values.first).floatValue();
        }
        return Math.abs(a) + Math.abs(b);
    }

    public static double diff(double a, double b) {
        if (a <= 0.0 && b <= 0.0 || a > 0.0 && b > 0.0) {
            Pair<Double, Double> values = EMath.compareValues(Math.abs(a), Math.abs(b));
            return (Double)values.second - (Double)values.first;
        }
        return Math.abs(a) + Math.abs(b);
    }

    public static int diff(int a, int b) {
        if (a <= 0 == b <= 0) {
            Pair<Integer, Integer> values = EMath.compareValues(Math.abs(a), Math.abs(b));
            return (Integer)values.second - (Integer)values.first;
        }
        return Math.abs(a) + Math.abs(b);
    }

    public static Pair<Integer, Integer> compareValues(int a, int b) {
        int small;
        int large;
        if (Math.abs(a) > Math.abs(b)) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        return Pair.of(small, large);
    }

    public static Pair<Float, Float> compareValues(float a, float b) {
        float small;
        float large;
        if (Math.abs(a) > Math.abs(b)) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        return Pair.of(Float.valueOf(small), Float.valueOf(large));
    }

    public static Pair<Double, Double> compareValues(double a, double b) {
        double small;
        double large;
        if (Math.abs(a) > Math.abs(b)) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        return Pair.of(small, large);
    }

    public static double parabolaValue(double xVector, double yVector, double xPoint, double yPoint, double x) {
        return (yPoint - yVector) / Math.pow(xPoint - xVector, 2.0) * Math.pow(x - xVector, 2.0) + yVector;
    }

    public static double smoothCurveValue(double x) {
        return EMath.smoothCurveValue(Pair.of(0.0, 0.0), Pair.of(1.0, 1.0), EMath.clamp(0.0, 1.0, x));
    }

    public static double smoothCurveValue(Pair<Double, Double> start, Pair<Double, Double> end, double x) {
        double length = EMath.diff((Double)start.first, (Double)end.first);
        double height = EMath.diff((Double)start.second, (Double)end.second);
        double lengthHalf = (Double)start.first + length / 2.0;
        CurveType type = (Double)start.second < (Double)end.second ? CurveType.ASCENDING : CurveType.DESCENDING;
        switch (type) {
            case ASCENDING: {
                double heightHalf = (Double)start.second + height / 2.0;
                if (x < lengthHalf) {
                    return EMath.parabolaValue((Double)start.first, (Double)start.second, lengthHalf, heightHalf, x);
                }
                return EMath.parabolaValue((Double)end.first, (Double)end.second, lengthHalf, heightHalf, x);
            }
            case DESCENDING: {
                double heightHalf = (Double)end.second + height / 2.0;
                if (x < lengthHalf) {
                    return EMath.parabolaValue((Double)start.first, (Double)start.second, lengthHalf, heightHalf, x);
                }
                return EMath.parabolaValue((Double)end.first, (Double)end.second, lengthHalf, heightHalf, x);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }

    private static enum CurveType {
        ASCENDING,
        DESCENDING;

    }
}

