/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.updater.butlerupdater;

import LandLord.landlord.eldoutilities.updater.Updater;
import LandLord.landlord.eldoutilities.updater.butlerupdater.ButlerUpdateData;
import LandLord.landlord.eldoutilities.updater.butlerupdater.UpdateCheckResponse;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ButlerUpdateChecker
extends Updater<ButlerUpdateData> {
    private UpdateCheckResponse response;

    public ButlerUpdateChecker(ButlerUpdateData data) {
        super(data);
    }

    @Override
    protected Optional<String> getLatestVersion(ButlerUpdateData data) {
        HttpURLConnection con;
        Plugin plugin = data.plugin();
        try {
            URL url = new URL(data.host() + "/check?version=" + plugin.getDescription().getVersion() + "&id=" + data.butlerId() + "&devbuild=" + false);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.FINEST, "Could not open connection.", e);
            return Optional.empty();
        }
        con.setRequestProperty("Content-Type", "application/json; utf-8");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        try {
            if (con.getResponseCode() != 200) {
                plugin.getLogger().log(Level.FINEST, "Received non 200 request.");
                return Optional.empty();
            }
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.INFO, "Could not read response.", e);
            return Optional.empty();
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            StringBuilder builder = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                builder.append(responseLine.trim());
            }
            this.response = (UpdateCheckResponse)new Gson().fromJson(builder.toString(), UpdateCheckResponse.class);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.FINEST, "Could not read response.", e);
            return Optional.empty();
        }
        return Optional.ofNullable(this.response.latestVersion());
    }

    @Override
    protected boolean update() {
        String hash;
        File pluginFile;
        Field fileField;
        URL url;
        if (this.response == null) {
            return false;
        }
        Plugin plugin = ((ButlerUpdateData)this.getData()).plugin();
        plugin.getLogger().info("\u00a72>------------------------<");
        plugin.getLogger().info("\u00a72> Performing auto update <");
        plugin.getLogger().info("\u00a72>------------------------<");
        plugin.getLogger().info("\u00a72Performing auto update.");
        try {
            url = new URL(((ButlerUpdateData)this.getData()).host() + "/download?id=" + ((ButlerUpdateData)this.getData()).butlerId() + "&version=" + this.response.latestVersion());
        }
        catch (MalformedURLException e) {
            plugin.getLogger().log(Level.CONFIG, "Could not create download url.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        plugin.getLogger().info("\u00a72Downloaded new file.");
        String plugins = plugin.getDataFolder().getParent();
        File updateDirectory = new File(Paths.get(plugins, "update").toString());
        if (!updateDirectory.exists() && !updateDirectory.mkdirs()) {
            plugin.getLogger().warning("\u00a7cCould not create update directory.");
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        try {
            fileField = JavaPlugin.class.getDeclaredField("file");
        }
        catch (NoSuchFieldException e) {
            plugin.getLogger().log(Level.WARNING, "\u00a7cCould not find field file in plugin.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        fileField.setAccessible(true);
        try {
            pluginFile = (File)fileField.get(plugin);
        }
        catch (IllegalAccessException e) {
            plugin.getLogger().log(Level.WARNING, "Could not retrieve file of plugin.", e);
            return false;
        }
        File updateFile = Paths.get(updateDirectory.getAbsolutePath(), pluginFile.getName()).toFile();
        try (InputStream input = url.openStream();){
            Files.copy(input, updateFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not create update file.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            return false;
        }
        plugin.getLogger().info("\u00a72Calculate checksum.");
        try {
            hash = Hashing.sha256().hashBytes(Files.readAllBytes(updateFile.toPath())).toString();
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to create hash from update file.", e);
            plugin.getLogger().warning("\u00a7cAborting Update.");
            updateFile.delete();
            return false;
        }
        if (!hash.equals(this.response.hash())) {
            plugin.getLogger().warning("\u00a7cChecksums of update file is not as expected.");
            plugin.getLogger().warning("\u00a7cAborting Update.");
            updateFile.delete();
            return false;
        }
        plugin.getLogger().info("\u00a72Checksums of update file is correct.");
        plugin.getLogger().info("\u00a72File " + pluginFile.getName() + " will be replaced with the new version on next startup.");
        plugin.getLogger().info("\u00a72>----------------------------------------------------<");
        plugin.getLogger().info("\u00a72> Update downloaded. Please restart to apply update. <");
        plugin.getLogger().info("\u00a72>----------------------------------------------------<");
        return true;
    }
}

