/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.updater;

import LandLord.landlord.eldoutilities.updater.UpdateData;
import LandLord.landlord.eldoutilities.updater.butlerupdater.ButlerUpdateChecker;
import LandLord.landlord.eldoutilities.updater.butlerupdater.ButlerUpdateData;
import LandLord.landlord.eldoutilities.updater.notifier.DownloadedNotifier;
import LandLord.landlord.eldoutilities.updater.notifier.UpdateNotifier;
import LandLord.landlord.eldoutilities.updater.spigotupdater.SpigotUpdateChecker;
import LandLord.landlord.eldoutilities.updater.spigotupdater.SpigotUpdateData;
import java.util.Optional;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class Updater<T extends UpdateData>
extends BukkitRunnable
implements Listener {
    private final Plugin plugin;
    private final T data;
    private String latestVersion;
    private boolean notifyActive;
    private boolean updateAvailable;
    private boolean downloaded;

    protected Updater(T data) {
        this.plugin = ((UpdateData)data).plugin();
        this.data = data;
    }

    public static Updater<?> spigot(SpigotUpdateData data) {
        return new SpigotUpdateChecker(data);
    }

    public static Updater<?> butler(ButlerUpdateData data) {
        return new ButlerUpdateChecker(data);
    }

    public void run() {
        this.performCheck(true);
    }

    public final boolean performCheck(boolean silent) {
        Optional<String> optLatest;
        if (this.updateAvailable) {
            return true;
        }
        if (!silent) {
            this.plugin.getLogger().info("\u00a72Checking for new Version...");
        }
        if (!(optLatest = this.getLatestVersion(this.data)).isPresent()) {
            this.plugin.getLogger().info("Could not check latest version.");
            return false;
        }
        this.latestVersion = optLatest.get();
        this.updateAvailable = this.evaluate(this.latestVersion);
        if (this.updateAvailable) {
            this.logUpdateMessage();
            if (((UpdateData)this.data).isAutoUpdate()) {
                if (!this.downloaded) {
                    this.downloaded = this.update();
                }
                this.registerListener(new DownloadedNotifier(this.plugin, ((UpdateData)this.data).notifyPermission(), this.latestVersion, this.downloaded));
            } else {
                this.registerListener(new UpdateNotifier(this.plugin, ((UpdateData)this.data).notifyPermission(), this.latestVersion));
            }
        } else if (!silent) {
            this.plugin.getLogger().info("\u00a72Plugin is up to date.");
        }
        return this.updateAvailable;
    }

    protected abstract Optional<String> getLatestVersion(T var1);

    private boolean evaluate(String latestVersion) {
        return !this.plugin.getDescription().getVersion().equalsIgnoreCase(latestVersion);
    }

    protected boolean update() {
        return false;
    }

    public BukkitTask start() {
        return this.runTaskTimerAsynchronously(this.plugin, 40L, 432000L);
    }

    private void logUpdateMessage() {
        this.plugin.getLogger().info("\u00a72New version of \u00a76" + this.plugin.getName() + "\u00a72 available.");
        this.plugin.getLogger().info("\u00a72Newest version: \u00a73" + this.latestVersion + "! Current version: \u00a7c" + this.plugin.getDescription().getVersion() + "\u00a72!");
        this.plugin.getLogger().info("\u00a72Download new version here: \u00a76" + this.plugin.getDescription().getWebsite());
    }

    private void registerListener(Listener listener) {
        if (((UpdateData)this.data).isNotifyUpdate() && !this.notifyActive) {
            this.notifyActive = true;
            this.plugin.getServer().getPluginManager().registerEvents(listener, this.plugin);
        }
    }

    public T getData() {
        return this.data;
    }
}

