/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.threading.futures;

import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.threading.futures.FutureResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitFutureResult<T>
implements FutureResult<T> {
    private final CompletableFuture<T> future;

    private BukkitFutureResult(CompletableFuture<T> future) {
        this.future = future;
    }

    public static <T> BukkitFutureResult<T> of(CompletableFuture<T> future) {
        return new BukkitFutureResult<T>(future);
    }

    @Override
    public void whenComplete(@NotNull Consumer<? super T> callback) {
        this.whenComplete(EldoUtilities.getInstanceOwner(), callback);
    }

    @Override
    public void whenComplete(@NotNull Consumer<? super T> callback, Consumer<Throwable> throwable) {
        this.whenComplete(EldoUtilities.getInstanceOwner(), callback, throwable);
    }

    @Override
    public void whenComplete(@NotNull Plugin plugin, @NotNull Consumer<? super T> callback, Consumer<Throwable> throwableConsumer) {
        Executor executor = r -> plugin.getServer().getScheduler().runTask(plugin, r);
        ((CompletableFuture)this.future.thenAcceptAsync((Consumer)callback, executor)).exceptionally(throwable -> {
            throwableConsumer.accept((Throwable)throwable);
            return null;
        });
    }

    @Override
    public void whenComplete(@NotNull Plugin plugin, @NotNull Consumer<? super T> callback) {
        this.whenComplete(plugin, callback, throwable -> EldoUtilities.getInstanceOwner().getLogger().log(Level.SEVERE, "Exception in Future Result", (Throwable)throwable));
    }

    @Override
    @Nullable
    public T join() {
        return this.future.join();
    }

    @Override
    @NotNull
    public CompletableFuture<T> asFuture() {
        return this.future.thenApply(Function.identity());
    }
}

