/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.threading;

import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class ReschedulingTask {
    private final Plugin plugin;
    private BukkitRunnable task;
    private boolean active = true;

    public ReschedulingTask(Plugin plugin) {
        this.plugin = plugin;
    }

    public void schedule() {
        if (!this.isActive()) {
            return;
        }
        if (!this.isRunning()) {
            this.task = new InternalTask(this::run);
            this.task.runTaskTimer(this.plugin, 0L, 1L);
            this.plugin.getLogger().fine(this.getClass().getSimpleName() + " of " + this.plugin.getName() + " started.");
        }
    }

    public void cancel() {
        if (this.isRunning()) {
            this.task.cancel();
            this.task = null;
            this.plugin.getLogger().fine(this.getClass().getSimpleName() + " of " + this.plugin.getName() + " paused.");
        }
    }

    public void shutdown() {
        this.active = false;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract void run();

    public Plugin getPlugin() {
        return this.plugin;
    }

    private static class InternalTask
    extends BukkitRunnable {
        private final Runnable runnable;

        public InternalTask(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

