/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.threading;

import LandLord.landlord.eldoutilities.threading.TaskStatistics;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.scheduler.BukkitRunnable;

public class IteratingTask<T>
extends BukkitRunnable {
    private static final int MAX_DURATION_TARGET = 50;
    private final Iterator<T> iterator;
    private final Predicate<T> processor;
    private final Consumer<TaskStatistics> statisticsConsumer;
    private final TaskStatistics statistics;

    public IteratingTask(Iterable<T> iterable, Predicate<T> processor, Consumer<TaskStatistics> statisticsConsumer) {
        this.iterator = iterable.iterator();
        this.processor = processor;
        this.statisticsConsumer = statisticsConsumer;
        this.statistics = new TaskStatistics();
    }

    public final void run() {
        long duration;
        long start = System.currentTimeMillis();
        do {
            if (!this.iterator.hasNext()) {
                this.statistics.addTime(System.currentTimeMillis() - start);
                this.cancel();
                this.statisticsConsumer.accept(this.statistics);
                return;
            }
            T next = this.iterator.next();
            if (!this.processor.test(next)) continue;
            this.statistics.processElement();
        } while ((duration = System.currentTimeMillis() - start) < 50L);
        this.statistics.addTime(duration);
    }
}

