/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.simplecommands;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.utils.ArrayUtil;
import LandLord.landlord.eldoutilities.utils.Parser;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.internal.LinkedHashTreeMap;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;

public final class TabCompleteUtil {
    private static final Set<String> PLAYER_NAMES = new HashSet<String>();
    private static final Set<String> ONLINE_NAMES = new HashSet<String>();
    public static final char HIGHLIGHT = '6';
    public static final long OFFLINE_PLAYER_CACHE_SIZE = 1000L;
    private static Instant lastPlayerRefresh = Instant.now();
    private static final Set<String> smartMats;
    private static final Map<String, List<String>> smartShortMats;
    private static final Map<String, List<String>> smartPartMats;
    private static final Pattern SHORT_NAME;
    private static final Cache<String, List<String>> SMART_MAT_RESULTS;

    private TabCompleteUtil() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    private static String getShortName(Material mat) {
        Matcher matcher = SHORT_NAME.matcher(mat.name());
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(matcher.group(1));
        }
        return builder.toString();
    }

    private static Set<String> getParts(Material mat) {
        return Arrays.stream(mat.name().split("_")).collect(Collectors.toSet());
    }

    public static List<String> completeMaterial(String value, boolean lowerCase) {
        value = value.toLowerCase(Locale.ROOT);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (Map.Entry<String, List<String>> entry : smartShortMats.entrySet()) {
            if (!entry.getKey().startsWith(value)) continue;
            results.addAll((Collection)entry.getValue());
        }
        results.addAll(TabCompleteUtil.complete(value, smartMats));
        for (Map.Entry<String, List<String>> entry : smartPartMats.entrySet()) {
            if (!entry.getKey().startsWith(value)) continue;
            results.addAll((Collection)entry.getValue());
        }
        String finalValue = value.toUpperCase(Locale.ROOT);
        results.addAll(smartMats.stream().filter(mat -> mat.contains(finalValue)).collect(Collectors.toList()));
        return results.stream().map(name -> lowerCase ? name.toLowerCase(Locale.ROOT) : name).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, String ... inputs) {
        return ArrayUtil.startingWithInArray(value, inputs).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, Stream<String> inputs) {
        if (value.isEmpty()) {
            return inputs.collect(Collectors.toList());
        }
        String lowerValue = value.toLowerCase(Locale.ROOT);
        return inputs.filter(i -> i.toLowerCase().startsWith(lowerValue)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, Collection<String> inputs) {
        return TabCompleteUtil.complete(value, inputs.stream());
    }

    public static <T> List<String> complete(String value, Stream<T> inputs, Function<T, String> mapping) {
        return TabCompleteUtil.complete(value, inputs.map(mapping));
    }

    public static <T> List<String> complete(String value, Collection<T> inputs, Function<T, String> mapping) {
        return TabCompleteUtil.complete(value, inputs.stream(), mapping);
    }

    public static List<String> completeBoolean(String value) {
        return TabCompleteUtil.complete(value, "true", "false");
    }

    public static List<String> completeWorlds(String value) {
        return TabCompleteUtil.completeWorlds(value, ":");
    }

    public static List<String> completeWorlds(String value, String spaceReplace) {
        return TabCompleteUtil.complete(value, Bukkit.getWorlds(), (T w) -> w.getName().replace(" ", spaceReplace));
    }

    public static List<String> completePlayers(String value) {
        if (PLAYER_NAMES.isEmpty()) {
            PLAYER_NAMES.addAll(Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> Instant.ofEpochMilli(p.getLastPlayed()).isAfter(Instant.now().minus(30L, ChronoUnit.DAYS))).sorted(Comparator.comparingLong(OfflinePlayer::getLastPlayed)).limit(1000L).map(OfflinePlayer::getName).collect(Collectors.toSet()));
        }
        LinkedHashSet<String> complete = new LinkedHashSet<String>(TabCompleteUtil.complete(value, PLAYER_NAMES));
        complete.addAll(TabCompleteUtil.completeOnlinePlayers(value));
        return new ArrayList<String>(complete);
    }

    public static List<String> completeOnlinePlayers(String value) {
        LinkedHashSet<String> complete = new LinkedHashSet<String>(TabCompleteUtil.complete(value, PLAYER_NAMES));
        if (ONLINE_NAMES.isEmpty() || lastPlayerRefresh.isBefore(Instant.now().minus(10L, ChronoUnit.SECONDS))) {
            ONLINE_NAMES.clear();
            ONLINE_NAMES.addAll(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toSet()));
            lastPlayerRefresh = Instant.now();
        }
        complete.addAll(TabCompleteUtil.complete(value, ONLINE_NAMES));
        return new ArrayList<String>(complete);
    }

    public static <T extends Enum<T>> List<String> complete(String value, Class<T> clazz) {
        return TabCompleteUtil.complete(value, clazz, true, false);
    }

    public static <T extends Enum<T>> List<String> complete(String value, Class<T> clazz, boolean lowerCase, boolean strip) {
        return TabCompleteUtil.complete(value, Arrays.stream(clazz.getEnumConstants()).map(Enum::name).map(v -> lowerCase ? v.toLowerCase() : v).map(v -> strip ? v.replace("_", "") : v));
    }

    public static boolean isCommand(String value, String ... command) {
        return ArrayUtil.arrayContains(command, value);
    }

    public static List<String> completeDouble(String value, double min, double max, ILocalizer loc) {
        Optional<Double> d = Parser.parseDouble(value);
        ArrayList result = new ArrayList();
        if (d.isPresent()) {
            if (d.get() > max || d.get() < min) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidRange", Replacement.create("MIN", String.format("%.2f", min), new char[0]).addFormatting('6'), Replacement.create("MAX", String.format("%.2f", min), new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(min + "-" + max);
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeInt(String value, int min, int max, ILocalizer loc) {
        Optional<Integer> d = Parser.parseInt(value);
        if (d.isPresent()) {
            if (d.get() > max || d.get() < min) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidRange", Replacement.create("MIN", min, new char[0]).addFormatting('6'), Replacement.create("MAX", max, new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(min + "-" + max);
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeMinDouble(String value, double min, ILocalizer loc) {
        Optional<Double> val = Parser.parseDouble(value);
        if (val.isPresent()) {
            if (val.get() < min) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.tooLow", Replacement.create("MIN", min, new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(String.format("%.2f<", min));
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeMinInt(String value, int min, ILocalizer loc) {
        Optional<Integer> val = Parser.parseInt(value);
        if (val.isPresent()) {
            if (val.get() < min) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.tooLow", Replacement.create("MIN", min, new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(min + "<");
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeMaxDouble(String value, double max, ILocalizer loc) {
        Optional<Double> val = Parser.parseDouble(value);
        if (val.isPresent()) {
            if (val.get() > max) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.tooLarge", Replacement.create("MAX", max, new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(String.format("%.2f", max) + ">");
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeMaxInt(String value, int max, ILocalizer loc) {
        Optional<Integer> val = Parser.parseInt(value);
        if (val.isPresent()) {
            if (val.get() > max) {
                return TabCompleteUtil.singleEntryList(loc.getMessage("error.tooLarge", Replacement.create("MAX", max, new char[0]).addFormatting('6')));
            }
            return TabCompleteUtil.singleEntryList(max + ">");
        }
        return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidNumber", new Replacement[0]));
    }

    public static List<String> completeFreeInput(String value, int maxLength, String defaultComplete, ILocalizer loc) {
        if (value.length() > maxLength) {
            return TabCompleteUtil.singleEntryList(loc.getMessage("error.invalidLength", Replacement.create("MAX", maxLength, new char[0]).addFormatting('6')));
        }
        return TabCompleteUtil.singleEntryList(defaultComplete);
    }

    public static <T> List<T> singleEntryList(T value) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(value);
        return list;
    }

    static {
        SHORT_NAME = Pattern.compile("(?:(?:^|_)(.))");
        SMART_MAT_RESULTS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        smartMats = new LinkedHashSet<String>();
        smartShortMats = new LinkedHashTreeMap();
        smartPartMats = new LinkedHashTreeMap();
        for (Material material : Material.values()) {
            String name = material.name();
            if (name.startsWith("LEGACY")) continue;
            smartShortMats.computeIfAbsent(TabCompleteUtil.getShortName(material).toLowerCase(Locale.ROOT), k -> new ArrayList()).add(name);
            smartMats.add(name);
            for (String part : TabCompleteUtil.getParts(material)) {
                smartPartMats.computeIfAbsent(part.toLowerCase(Locale.ROOT), k -> new ArrayList()).add(name);
            }
        }
    }
}

