/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.simplecommands;

import LandLord.landlord.eldoutilities.localization.DummyLocalizer;
import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.messages.MessageChannel;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import LandLord.landlord.eldoutilities.messages.MessageType;
import LandLord.landlord.eldoutilities.utils.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EldoCommand
implements TabExecutor {
    private final Map<String, TabExecutor> subCommands = new HashMap<String, TabExecutor>();
    private final Plugin plugin;
    private ILocalizer localizer;
    private MessageSender messageSender;
    private String[] registeredCommands = new String[0];
    private TabExecutor defaultCommand;

    public EldoCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    protected static boolean argumentsInvalid(CommandSender sender, MessageSender messageSender, ILocalizer localizer, String[] args, int length, String syntax) {
        if (args.length < length) {
            messageSender.sendError(sender, localizer.getMessage("error.invalidArguments", Replacement.create("SYNTAX", localizer.localize(syntax, new Replacement[0]), new char[0]).addFormatting('6')));
            return true;
        }
        return false;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            if (this.defaultCommand != null) {
                return this.defaultCommand.onCommand(sender, command, label, args);
            }
            return true;
        }
        String[] newArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        return this.getCommand(args[0]).map(c -> c.onCommand(sender, command, args[0], newArgs)).orElse(false);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String[] newArgs;
        if (args.length == 1) {
            return ArrayUtil.startingWithInArray(args[0], this.registeredCommands).collect(Collectors.toList());
        }
        String[] stringArray = newArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        if (args.length == 0) {
            return Collections.emptyList();
        }
        return this.getCommand(args[0]).map(c -> c.onTabComplete(sender, command, args[0], newArgs)).orElse(Collections.singletonList(this.localizer().getMessage("error.invalidCommand", new Replacement[0])));
    }

    private Optional<TabExecutor> getCommand(String command) {
        for (Map.Entry<String, TabExecutor> entry : this.subCommands.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(command)) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public final void registerCommand(String command, TabExecutor executor) {
        this.subCommands.put(command, executor);
        this.registeredCommands = new String[this.subCommands.size()];
        this.subCommands.keySet().toArray(this.registeredCommands);
    }

    public final void setDefaultCommand(TabExecutor defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    protected final ILocalizer localizer() {
        if (this.localizer == null || this.localizer instanceof DummyLocalizer) {
            this.localizer = ILocalizer.getPluginLocalizer(this.plugin);
        }
        return this.localizer;
    }

    protected final MessageSender messageSender() {
        if (this.messageSender == null || this.messageSender.isDefault()) {
            this.messageSender = MessageSender.getPluginMessageSender(this.plugin);
        }
        return this.messageSender;
    }

    protected boolean argumentsInvalid(CommandSender sender, String[] args, int length, String syntax) {
        return EldoCommand.argumentsInvalid(sender, this.messageSender(), this.localizer(), args, length, syntax);
    }

    protected boolean denyPlayer(CommandSender sender) {
        if (this.isPlayer(sender)) {
            this.messageSender().sendLocalized(MessageChannel.CHAT, MessageType.ERROR, sender, "error.notAsPlayer", new Replacement[0]);
            return true;
        }
        return false;
    }

    protected boolean denyConsole(CommandSender sender) {
        if (this.isConsole(sender)) {
            this.messageSender().sendLocalized(MessageChannel.CHAT, MessageType.ERROR, sender, "error.notAsConsole", new Replacement[0]);
            return true;
        }
        return false;
    }

    protected boolean denyAccess(CommandSender actor, String ... permissions) {
        return this.denyAccess(actor, false, permissions);
    }

    protected boolean denyAccess(CommandSender actor, boolean silent, String ... permissions) {
        if (actor == null) {
            return false;
        }
        Player player = null;
        if (actor instanceof Player) {
            player = (Player)actor;
        }
        if (player == null) {
            return false;
        }
        for (String permission : permissions) {
            if (!player.hasPermission(permission)) continue;
            return false;
        }
        if (!silent) {
            this.messageSender().sendMessage((CommandSender)player, this.localizer().getMessage("error.permission", Replacement.create("PERMISSION", String.join((CharSequence)", ", permissions), new char[0]).addFormatting('6')));
        }
        return true;
    }

    protected Player getPlayerFromSender(CommandSender sender) {
        return this.isPlayer(sender) ? (Player)sender : null;
    }

    protected boolean isConsole(CommandSender sender) {
        return !(sender instanceof Player);
    }

    protected boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    protected boolean invalidRange(CommandSender sender, double value, double min, double max) {
        if (value > max || value < min) {
            this.messageSender().sendError(sender, this.localizer().getMessage("error.invalidRange", Replacement.create("MIN", min, new char[0]).addFormatting('6'), Replacement.create("MAX", max, new char[0]).addFormatting('6')));
            return true;
        }
        return false;
    }

    protected <T extends Enum<T>> boolean invalidEnumValue(CommandSender sender, T value, Class<T> clazz) {
        if (value == null) {
            this.messageSender().sendError(sender, this.localizer().getMessage("error.invalidEnumValue", Replacement.create("VALUES", Arrays.stream(clazz.getEnumConstants()).map(e -> e.name().toLowerCase()).collect(Collectors.joining(" ")), new char[0]).addFormatting('6')));
            return true;
        }
        return false;
    }

    protected boolean invalidRange(CommandSender sender, int value, int min, int max) {
        return this.invalidRange(sender, (double)value, (double)min, (double)max);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

