/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.serialization;

import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.utils.EnumUtil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class TypeResolvingMap
extends AbstractMap<String, Object> {
    private final Map<String, Object> delegate;

    TypeResolvingMap(Map<String, Object> delegate) {
        this.delegate = new LinkedHashMap<String, Object>(delegate);
        this.delegate.entrySet().removeIf(e -> e.getValue() == null);
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public <T> T getValue(String key) {
        return (T)this.get(key);
    }

    public <T, V> void listToMap(Map<T, V> map, String key, Function<V, T> valueToKey) {
        List values = (List)this.getValue(key);
        values.forEach((? super T v) -> map.put(valueToKey.apply(v), v));
    }

    public <T> T getValueOrDefault(String key, T defaultValue) {
        return (T)this.delegate.getOrDefault(key, defaultValue);
    }

    public UUID getValueOrDefault(String key, UUID defaultValue) {
        return this.getValueOrDefault(key, defaultValue, UUID::fromString);
    }

    public <T extends Enum<T>> T getValueOrDefault(String key, T defaultValue, Class<T> clazz) {
        return EnumUtil.parse(this.getValueOrDefault(key, defaultValue.name()), clazz, defaultValue);
    }

    public <T extends Enum<T>> List<T> getValueOrDefault(String key, List<T> defaultValue, Class<T> clazz) {
        List names = (List)this.getValue(key);
        if (names == null) {
            return defaultValue;
        }
        return names.stream().map(name -> EnumUtil.parse(name, clazz)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public <T> T getValueOrDefault(String key, T defaultValue, Function<String, T> valueConverter) {
        if (this.containsKey(key)) {
            return this.getValue(key, valueConverter);
        }
        return defaultValue;
    }

    @NotNull
    public <K, V> Map<K, V> getMap(String key, BiFunction<String, V, K> keyOrValueToKey) {
        List mapObjects = (List)this.getValue(key);
        HashMap results = new HashMap();
        if (mapObjects == null) {
            return results;
        }
        mapObjects.forEach((? super T e) -> {
            EldoUtilities.logger().config("Building map entry from: " + e);
            if (e == null) {
                EldoUtilities.logger().config("Map is null");
                return;
            }
            results.put(keyOrValueToKey.apply(e.getKey(), e.getObject()), e.getObject());
        });
        return results;
    }

    public <T> T getValue(String key, Function<String, T> valueConverter) {
        String value = (String)this.getValue(key);
        return value == null ? null : (T)valueConverter.apply(value);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.delegate.keySet();
    }
}

