/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.serialization;

import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.serialization.KebabNamingStrategy;
import LandLord.landlord.eldoutilities.serialization.NamingStrategy;
import LandLord.landlord.eldoutilities.serialization.TypeResolvingMap;
import LandLord.landlord.eldoutilities.serialization.wrapper.MapEntry;
import LandLord.landlord.eldoutilities.utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class SerializationUtil {
    private static final NamingStrategy NAMING_STRATEGY = new KebabNamingStrategy();

    private SerializationUtil() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Map<String, Object> map) {
        return new Builder(map);
    }

    public static <T, U> BiFunction<T, U, String> keyToString() {
        return (k, v) -> k.toString();
    }

    public static <T, U> BiFunction<T, U, Object> valueOnly(Function<U, ?> valueFunction) {
        return (k, v) -> valueFunction.apply(v);
    }

    public static <T, U> BiFunction<T, U, String> keyToPrefixedString(String prefix) {
        return (k, v) -> prefix + k.toString();
    }

    public static TypeResolvingMap mapOf(Map<String, Object> serialized) {
        return new TypeResolvingMap(serialized);
    }

    public static Map<String, Object> objectToMap(Object obj) {
        Field[] declaredFields;
        Builder builder = SerializationUtil.newBuilder();
        for (Field declaredField : declaredFields = ReflectionUtil.getAllFields(obj)) {
            declaredField.setAccessible(true);
            if (Modifier.isTransient(declaredField.getModifiers())) continue;
            try {
                builder.add(declaredField.getName(), declaredField.get(obj));
            }
            catch (IllegalAccessException e) {
                EldoUtilities.logger().log(Level.WARNING, "Could not access field " + declaredField.getName(), e);
            }
        }
        return builder.build();
    }

    public static <T> void mapOnObject(Map<String, Object> objectMap, T obj) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = ReflectionUtil.getAllFields(obj)) {
            declaredField.setAccessible(true);
            if (Modifier.isTransient(declaredField.getModifiers()) || !objectMap.containsKey(declaredField.getName())) continue;
            try {
                declaredField.set(obj, objectMap.get(declaredField.getName()));
            }
            catch (IllegalAccessException e) {
                EldoUtilities.logger().log(Level.WARNING, "Could not access field " + declaredField.getName(), e);
            }
        }
    }

    public static final class Builder {
        private final Map<String, Object> serialized;

        public Builder() {
            this.serialized = new LinkedHashMap<String, Object>();
        }

        public Builder(Map<String, Object> map) {
            this.serialized = new LinkedHashMap<String, Object>(map);
        }

        public Builder add(String key, Object value) {
            this.serialized.put(key, value);
            return this;
        }

        public <T> Builder add(String key, T value, Function<T, String> toString) {
            return this.add(key, toString.apply(value));
        }

        public Builder add(String key, Map<?, ?> value) {
            return this.add(key, new ArrayList(value.values()));
        }

        public <K, V> Builder addMap(String key, Map<K, V> map, BiFunction<K, V, String> keyToString) {
            return this.add(key, map.entrySet().stream().map(e -> new MapEntry((String)keyToString.apply(e.getKey(), e.getValue()), e.getValue())).collect(Collectors.toList()));
        }

        public Builder add(String key, Enum<?> enumValue) {
            return this.add(key, enumValue.name());
        }

        public Builder add(String key, Collection<?> collection) {
            this.serialized.put(key, new ArrayList(collection));
            return this;
        }

        public Builder add(Object value) {
            return this.add(NAMING_STRATEGY.adapt(value.getClass()), value);
        }

        public Builder add(Enum<?> enumValue) {
            return this.add(NAMING_STRATEGY.adapt(enumValue.getClass()), enumValue);
        }

        public Builder add(String key, UUID uuid) {
            return this.add(key, uuid.toString());
        }

        public <K, V> Builder add(Map<K, V> map, BiFunction<K, V, String> keyFunction, BiFunction<K, V, Object> valueFunction) {
            map.forEach((k, v) -> this.add((String)keyFunction.apply(k, v), valueFunction.apply(k, v)));
            return this;
        }

        public <T extends Enum<?>> Builder addEnum(String key, Collection<T> values) {
            return this.add(key, values.stream().map(Enum::name).collect(Collectors.toCollection(ArrayList::new)));
        }

        public Builder add(Map<String, Object> map) {
            map.forEach(this::add);
            return this;
        }

        public Map<String, Object> build() {
            return this.serialized;
        }
    }
}

