/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.scheduling;

import LandLord.landlord.eldoutilities.threading.ReschedulingTask;
import java.util.Collection;
import org.bukkit.plugin.Plugin;

public abstract class SelfSchedulingWorker<V, T extends Collection<V>>
extends ReschedulingTask {
    private final T tasks = this.getQueueImplementation();
    private int idleTicks;
    private int maxIdleTicks = 200;

    public SelfSchedulingWorker(Plugin plugin, int maxIdleTicks) {
        this(plugin);
        this.maxIdleTicks = maxIdleTicks;
    }

    public SelfSchedulingWorker(Plugin plugin) {
        super(plugin);
    }

    protected abstract void execute(V var1);

    protected void tick() {
    }

    @Override
    public final void run() {
        if (!this.tasks.isEmpty()) {
            this.tick();
            for (Object task : this.tasks) {
                this.execute(task);
            }
        } else {
            ++this.idleTicks;
            if (this.idleTicks >= this.maxIdleTicks) {
                this.cancel();
            }
        }
    }

    protected final void register(V object) {
        if (!this.isActive()) {
            return;
        }
        this.tasks.add(object);
        if (!this.isRunning()) {
            this.schedule();
        }
        this.idleTicks = 0;
    }

    public final void unregister(V object) {
        this.tasks.remove(object);
    }

    protected abstract T getQueueImplementation();

    @Override
    public final void shutdown() {
        super.shutdown();
        for (Object task : this.tasks) {
            this.execute(task);
        }
        this.tasks.clear();
    }
}

