/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.scheduling;

import LandLord.landlord.eldoutilities.threading.ReschedulingTask;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Predicate;
import org.bukkit.plugin.Plugin;

public abstract class QueuingSelfSchedulingTask<T>
extends ReschedulingTask {
    private static final int MAX_DURATION_TARGET = 50;
    private final Queue<T> tasks = this.getQueueImplementation();
    private int idleTicks;
    private int maxIdleTicks = 200;

    public QueuingSelfSchedulingTask(Plugin plugin, int maxIdleTicks) {
        this(plugin);
        this.maxIdleTicks = maxIdleTicks;
    }

    public QueuingSelfSchedulingTask(Plugin plugin) {
        super(plugin);
    }

    public abstract void execute(T var1);

    public void tick() {
    }

    @Override
    public final void run() {
        this.tick();
        long start = System.currentTimeMillis();
        long duration = 0L;
        while (!this.tasks.isEmpty() && this.proceed(this.tasks.peek()) && duration < 50L) {
            this.execute(this.tasks.poll());
            duration = System.currentTimeMillis() - start;
        }
        if (this.tasks.isEmpty()) {
            ++this.idleTicks;
            if (this.idleTicks >= this.maxIdleTicks) {
                this.cancel();
            }
        }
    }

    protected boolean proceed(T object) {
        return true;
    }

    protected final void schedule(T object) {
        if (!this.isActive()) {
            return;
        }
        this.tasks.add(object);
        if (!this.isRunning()) {
            this.schedule();
        }
        this.idleTicks = 0;
    }

    protected Queue<T> getQueueImplementation() {
        return new ArrayDeque();
    }

    @Override
    public final void shutdown() {
        super.shutdown();
        for (Object task : this.tasks) {
            this.execute(task);
        }
        this.tasks.clear();
    }

    protected boolean remove(T o) {
        return this.tasks.remove(o);
    }

    protected boolean removeIf(Predicate<? super T> filter) {
        return this.tasks.removeIf(filter);
    }
}

