/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.scheduling;

import LandLord.landlord.eldoutilities.scheduling.QueuingSelfSchedulingTask;
import java.util.PriorityQueue;
import java.util.Queue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class DelayedActions
extends QueuingSelfSchedulingTask<DelayedTask> {
    private int currentTick;

    private DelayedActions(Plugin plugin) {
        super(plugin);
    }

    public static DelayedActions start(Plugin plugin) {
        return new DelayedActions(plugin);
    }

    @Override
    public void execute(DelayedTask object) {
        object.invoke();
    }

    @Override
    public void tick() {
        ++this.currentTick;
    }

    @Override
    protected Queue<DelayedTask> getQueueImplementation() {
        return new PriorityQueue<DelayedTask>();
    }

    public void schedule(Runnable runnable, int delay) {
        if (delay == 0) {
            runnable.run();
            return;
        }
        this.schedule(new DelayedTask(runnable, this.currentTick + delay));
    }

    @Override
    protected boolean proceed(DelayedTask object) {
        return object.tick <= this.currentTick;
    }

    protected static class DelayedTask
    implements Comparable<DelayedTask> {
        private final Runnable runnable;
        private final int tick;

        public DelayedTask(Runnable runnable, int tick) {
            this.runnable = runnable;
            this.tick = tick;
        }

        @Override
        public int compareTo(@NotNull DelayedTask o) {
            return Integer.compare(this.tick, o.tick);
        }

        public void invoke() {
            this.runnable.run();
        }
    }
}

