/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.plugin;

import LandLord.landlord.eldoutilities.commands.command.AdvancedCommand;
import LandLord.landlord.eldoutilities.commands.command.AdvancedCommandAdapter;
import LandLord.landlord.eldoutilities.configuration.EldoConfig;
import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.debug.DebugDataProvider;
import LandLord.landlord.eldoutilities.debug.data.EntryData;
import LandLord.landlord.eldoutilities.logging.DebugLogger;
import LandLord.landlord.eldoutilities.simplecommands.commands.FailsaveCommand;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public abstract class EldoPlugin
extends JavaPlugin
implements DebugDataProvider {
    private static EldoPlugin instance;
    private DebugLogger debugLogger;
    private FailsaveCommand failcmd;
    private ReloadListener reloadListener;

    public EldoPlugin() {
        EldoPlugin.registerSelf(this);
    }

    public EldoPlugin(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
        EldoPlugin.registerSelf(this);
    }

    private static void registerSelf(EldoPlugin eldoPlugin) {
        instance = eldoPlugin;
        for (Class<? extends ConfigurationSerializable> clazz : eldoPlugin.getConfigSerialization()) {
            ConfigurationSerialization.registerClass(clazz);
        }
        EldoUtilities.preWarm((Plugin)instance);
        EldoPlugin.instance.failcmd = new FailsaveCommand((Plugin)instance, instance.getDescription().getFullName().toLowerCase());
    }

    public static EldoPlugin getInstance() {
        return instance;
    }

    public static Logger logger() {
        return EldoPlugin.getInstance().getLogger();
    }

    @NotNull
    public Logger getLogger() {
        if (this.debugLogger == null) {
            this.debugLogger = new DebugLogger(this, super.getLogger());
            this.setLoggerLevel();
        }
        return this.debugLogger;
    }

    protected final void setLoggerLevel() {
        this.getLogger().setLevel(EldoConfig.getLogLevel((Plugin)this));
    }

    public final void registerCommand(String command, TabExecutor tabExecutor) {
        PluginCommand cmd = this.getCommand(command);
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)tabExecutor);
            return;
        }
        this.getLogger().warning("Command " + command + " not found!");
    }

    public final void registerCommand(AdvancedCommand command) {
        this.registerCommand(command.meta().name(), command);
    }

    public final void registerCommand(String command, AdvancedCommand executor) {
        this.registerCommand(command, AdvancedCommandAdapter.wrap((Plugin)this, executor));
    }

    public final void registerListener(Listener ... listener) {
        for (Listener l : listener) {
            this.getPluginManager().registerEvents(l, (Plugin)this);
        }
    }

    public final int scheduleRepeatingTask(Runnable task, int period) {
        return this.scheduleRepeatingTask(task, 100, period);
    }

    public final int scheduleRepeatingTask(Runnable task, int delay, int period) {
        return this.getScheduler().scheduleSyncRepeatingTask((Plugin)this, task, (long)delay, (long)period);
    }

    public final PluginManager getPluginManager() {
        return this.getServer().getPluginManager();
    }

    public final BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    public List<Class<? extends ConfigurationSerializable>> getConfigSerialization() {
        return Collections.emptyList();
    }

    public final void onLoad() {
        EldoPlugin.logger().config("Loading plugin.");
        try {
            this.onPluginLoad();
        }
        catch (Throwable e) {
            this.initFailsave("Plugin failed to load.", e);
        }
    }

    public void onPluginLoad() throws Throwable {
    }

    public final void onEnable() {
        Instant start = Instant.now();
        final boolean reload = this.isLocked();
        if (reload) {
            try {
                EldoPlugin.logger().config("Detected plugin reload.");
                this.onReload();
            }
            catch (Throwable e) {
                this.initFailsave("Plugin failed to reload.", e);
                return;
            }
        }
        this.reloadListener = new ReloadListener();
        this.registerListener(this.reloadListener);
        EldoUtilities.ignite((Plugin)instance);
        try {
            if (!reload) {
                EldoPlugin.logger().config("Detected initial plugin enable.");
            }
            this.onPluginEnable(reload);
            this.onPluginEnable();
        }
        catch (Throwable e) {
            this.initFailsave("Plugin failed to enable.", e);
            for (String cmd : this.getDescription().getCommands().keySet()) {
                try {
                    this.registerCommand(cmd, this.failcmd);
                }
                catch (Throwable ex) {
                    EldoPlugin.logger().log(Level.WARNING, "Failed to initialize failsafe command", ex);
                }
            }
            return;
        }
        EldoPlugin.logger().config("Scheduling post startup");
        new BukkitRunnable(){

            public void run() {
                Instant start = Instant.now();
                try {
                    EldoPlugin.this.onPostStart(reload);
                    EldoPlugin.this.onPostStart();
                }
                catch (Throwable e) {
                    EldoPlugin.this.initFailsave("Plugin post start failed.", e);
                    return;
                }
                long until = start.until(Instant.now(), ChronoUnit.MILLIS);
                EldoPlugin.logger().info("Post startup done. Required " + until + " ms.");
            }
        }.runTaskLater((Plugin)this, 1L);
        this.removeLock();
        long until = start.until(Instant.now(), ChronoUnit.MILLIS);
        EldoPlugin.logger().info("Enabled. Required " + until + " ms.");
    }

    private void initFailsave(String message, Throwable e) {
        EldoPlugin.logger().log(Level.SEVERE, message, e);
        EldoPlugin.logger().log(Level.SEVERE, "Initializing failsave mode.");
        FailsaveCommand failcmd = new FailsaveCommand((Plugin)instance, this.getDescription().getFullName().toLowerCase());
        for (String cmd : this.getDescription().getCommands().keySet()) {
            try {
                this.registerCommand(cmd, failcmd);
            }
            catch (Throwable ex) {
                EldoPlugin.logger().log(Level.WARNING, "Failed to initialize failsafe command", ex);
            }
        }
    }

    private void onReload() throws Throwable {
        EldoPlugin.logger().severe("\u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1 \u27f1");
        EldoPlugin.logger().severe("Detected server reload.");
        EldoPlugin.logger().severe("Reloading the server is highly discouraged and can lead to unexpected behaviour.");
        EldoPlugin.logger().severe("Please do not report any bugs caused by reloading the server.");
        EldoPlugin.logger().severe("\u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0 \u27f0");
        this.onPluginReload();
    }

    public void onPluginReload() throws Throwable {
    }

    public void onPostStart(boolean reload) throws Throwable {
    }

    public void onPostStart() throws Throwable {
    }

    public void onPluginEnable(boolean reload) throws Throwable {
    }

    public void onPluginEnable() throws Throwable {
    }

    public final void onDisable() {
        if (this.reloadListener.isReload()) {
            EldoPlugin.logger().severe("Plugin is disabled by server reload.");
            this.createLock();
        }
        EldoUtilities.shutdown();
        try {
            this.onPluginDisable();
        }
        catch (Throwable e) {
            EldoPlugin.logger().log(Level.SEVERE, "Plugin failed to shutdown correctly.", e);
        }
    }

    private Path getLockFile() {
        return this.getDataFolder().toPath().resolve("lock");
    }

    private void createLock() {
        try {
            Files.createFile(this.getLockFile(), new FileAttribute[0]);
        }
        catch (IOException e) {
            EldoPlugin.logger().config("Could not create lock file");
        }
    }

    private boolean isLocked() {
        return Files.exists(this.getLockFile(), new LinkOption[0]);
    }

    private void removeLock() {
        try {
            Files.deleteIfExists(this.getLockFile());
        }
        catch (IOException e) {
            EldoPlugin.logger().config("Could not resolve lock");
        }
    }

    public void onPluginDisable() throws Throwable {
    }

    @Override
    @NotNull
    public EntryData[] getDebugInformations() {
        return new EntryData[0];
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.failcmd.onCommand(sender, command, label, args);
    }

    private static class ReloadListener
    implements Listener {
        private boolean reload;

        private ReloadListener() {
        }

        @EventHandler
        public void onCommand(PlayerCommandPreprocessEvent event) {
            if ((event.getPlayer().hasPermission("bukkit.command.reload") || event.getPlayer().isOp()) && event.getMessage().startsWith("/reload")) {
                this.reload = true;
            }
        }

        @EventHandler
        public void onServercommand(ServerCommandEvent event) {
            if (event.getCommand().startsWith("reload")) {
                this.reload = true;
            }
        }

        public boolean isReload() {
            return this.reload;
        }
    }
}

