/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.permissions;

import LandLord.landlord.eldoutilities.utils.Parser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public final class PermUtil {
    private PermUtil() {
    }

    public static int findHighestIntPermission(Player player, String prefix, int defaultValue) {
        Collection<Integer> permission = PermUtil.findPermissions(player, prefix, true, string -> {
            Optional<Integer> optionalInt = Parser.parseInt(string);
            return optionalInt.orElse(null);
        });
        int max = defaultValue;
        for (int num : permission) {
            max = Math.max(max, num);
        }
        return max;
    }

    public static double findHighestDoublePermission(Player player, String prefix, double defaultValue) {
        Collection<Double> permission = PermUtil.findPermissions(player, prefix, true, string -> {
            Optional<Double> optionalInt = Parser.parseDouble(string);
            return optionalInt.orElse(null);
        });
        double max = defaultValue;
        for (double num : permission) {
            max = Math.max(max, num);
        }
        return max;
    }

    public static Collection<String> findPermissions(Player player, String prefix, boolean truncate) {
        return PermUtil.findPermissions(player, prefix, truncate, s -> s);
    }

    public static <T> Collection<@NotNull T> findPermissions(Player player, String prefix, boolean truncate, Function<String, T> parse) {
        Set permissions = player.getEffectivePermissions();
        HashSet<Object> matches = new HashSet<Object>();
        for (PermissionAttachmentInfo permission : permissions) {
            String perm;
            if (!permission.getValue() || !(perm = permission.getPermission()).toLowerCase().startsWith(prefix)) continue;
            if (truncate) {
                perm = perm.replace(prefix, "");
            }
            matches.add(parse.apply(perm));
        }
        matches.removeIf(Objects::isNull);
        return matches;
    }
}

