/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.messages.channeldata;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.messages.MessageChannel;
import LandLord.landlord.eldoutilities.messages.MessageType;
import LandLord.landlord.eldoutilities.messages.channeldata.ChannelData;

public final class TitleData
implements ChannelData {
    public static final TitleData DEFAULT = new TitleData(10, 50, 20, "");
    private final int fadeIn;
    private final int stay;
    private final int fadeOut;
    private String otherLine;

    private TitleData(int fadeIn, int stay, int fadeOut, String otherLine) {
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
        this.otherLine = otherLine;
    }

    public static TitleData forTime(int fadeIn, int stay, int fadeOut) {
        return new TitleData(fadeIn, stay, fadeOut, "");
    }

    public static TitleData forOtherLine(String otherLine) {
        return new TitleData(10, 50, 20, otherLine);
    }

    public static TitleData forFadeAndTime(int fadeIn, int stay, int fadeOut, String otherLine) {
        return new TitleData(fadeIn, stay, fadeOut, otherLine);
    }

    @Override
    public void localized(ILocalizer localizer, Replacement ... replacements) {
        this.otherLine = localizer.localize(this.otherLine, replacements);
    }

    @Override
    public void formatText(MessageType type, MessageChannel<? extends ChannelData> channel, String prefix) {
        type.forceColor(this.otherLine);
        this.otherLine = channel.addPrefix(this.otherLine, prefix);
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public String getOtherLine() {
        return this.otherLine;
    }
}

