/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.messages;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.messages.MessageChannel;
import LandLord.landlord.eldoutilities.messages.MessageType;
import LandLord.landlord.eldoutilities.messages.channeldata.ChannelData;
import LandLord.landlord.eldoutilities.messages.channeldata.TitleData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class MessageSender {
    private static final MessageSender DEFAULT_SENDER = new MessageSender(null, "");
    private static final Map<Class<? extends Plugin>, MessageSender> PLUGIN_SENDER = new HashMap<Class<? extends Plugin>, MessageSender>();
    private final Class<? extends Plugin> ownerPlugin;
    private String prefix;

    private MessageSender(Class<? extends Plugin> ownerPlugin, String prefix) {
        this.ownerPlugin = ownerPlugin;
        this.prefix = prefix;
    }

    @Deprecated
    public static MessageSender create(Class<? extends Plugin> plugin, String prefix, char messageColor, char errorColor) {
        return MessageSender.create(plugin, prefix, new char[]{messageColor}, new char[]{errorColor});
    }

    @Deprecated
    public static MessageSender create(Plugin plugin, String prefix, char messageColor, char errorColor) {
        return MessageSender.create(plugin.getClass(), prefix, new char[]{messageColor}, new char[]{errorColor});
    }

    @Deprecated
    public static MessageSender create(Plugin plugin, String prefix, char[] messageColor, char[] errorColor) {
        return MessageSender.create(plugin.getClass(), prefix, messageColor, errorColor);
    }

    @Deprecated
    public static MessageSender create(Class<? extends Plugin> plugin, String prefix, char[] messageColor, char[] errorColor) {
        return MessageSender.create(plugin, prefix);
    }

    public static MessageSender create(Plugin plugin, String prefix) {
        return MessageSender.create(plugin.getClass(), prefix);
    }

    public static MessageSender create(Class<? extends Plugin> plugin, String prefix) {
        if (plugin == null) {
            return DEFAULT_SENDER;
        }
        return PLUGIN_SENDER.compute(plugin, (k, v) -> v == null ? new MessageSender(plugin, prefix.trim() + " ") : v.update(prefix));
    }

    public static MessageSender getPluginMessageSender(@Nullable Plugin plugin) {
        if (plugin == null) {
            return DEFAULT_SENDER;
        }
        return MessageSender.getPluginMessageSender(plugin.getClass());
    }

    public static MessageSender getPluginMessageSender(@Nullable Class<? extends Plugin> plugin) {
        return plugin == null ? DEFAULT_SENDER : PLUGIN_SENDER.getOrDefault(plugin, DEFAULT_SENDER);
    }

    public static MessageSender getDefaultSender() {
        return DEFAULT_SENDER;
    }

    private MessageSender update(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public void sendMessage(CommandSender sender, String message) {
        this.send(MessageChannel.CHAT, MessageType.NORMAL, sender, message);
    }

    public void sendError(CommandSender sender, String message) {
        this.send(MessageChannel.CHAT, MessageType.ERROR, sender, message);
    }

    public void sendLocalizedMessage(CommandSender sender, String message, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.CHAT, MessageType.NORMAL, sender, message, replacements);
    }

    public void sendLocalizedError(CommandSender sender, String message, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.CHAT, MessageType.ERROR, sender, message, replacements);
    }

    @Deprecated
    public void sendTitle(Player player, String defaultColor, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.send(MessageChannel.TITLE, () -> defaultColor, (CommandSender)player, title, TitleData.forFadeAndTime(fadeIn, stay, fadeOut, subtitle));
    }

    @Deprecated
    public void sendTitle(Player player, String defaultColor, String title, String subtitle) {
        this.send(MessageChannel.TITLE, () -> defaultColor, (CommandSender)player, title, TitleData.forOtherLine(subtitle));
    }

    @Deprecated
    public void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.send(MessageChannel.TITLE, MessageType.NORMAL, (CommandSender)player, title, TitleData.forFadeAndTime(fadeIn, stay, fadeOut, subtitle));
    }

    @Deprecated
    public void sendTitle(Player player, String title, String subtitle) {
        this.send(MessageChannel.TITLE, MessageType.NORMAL, (CommandSender)player, title, TitleData.forOtherLine(subtitle));
    }

    @Deprecated
    public void sendLocalizedTitle(Player player, String defaultColor, String title, String subtitle, int fadeIn, int stay, int fadeOut, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.TITLE, () -> defaultColor, (CommandSender)player, title, TitleData.forFadeAndTime(fadeIn, stay, fadeOut, subtitle), replacements);
    }

    @Deprecated
    public void sendLocalizedTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.TITLE, MessageType.NORMAL, (CommandSender)player, title, TitleData.forFadeAndTime(fadeIn, stay, fadeOut, subtitle), replacements);
    }

    @Deprecated
    public void sendLocalizedTitle(Player player, String defaultColor, String title, String subtitle, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.TITLE, () -> defaultColor, (CommandSender)player, title, TitleData.forOtherLine(subtitle), replacements);
    }

    @Deprecated
    public void sendLocalizedTitle(Player player, String title, String subtitle, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.TITLE, MessageType.NORMAL, (CommandSender)player, title, TitleData.forOtherLine(subtitle), replacements);
    }

    @Deprecated
    public void sendLocalizedActionBar(Player player, String message, Replacement ... replacements) {
        this.sendLocalized(MessageChannel.ACTION_BAR, MessageType.NORMAL, (CommandSender)player, message, replacements);
    }

    @Deprecated
    public void sendActionBar(Player player, String message) {
        this.send(MessageChannel.ACTION_BAR, MessageType.NORMAL, (CommandSender)player, message);
    }

    private ILocalizer loc() {
        return ILocalizer.getPluginLocalizer(this.ownerPlugin);
    }

    public <T extends ChannelData> void sendLocalized(MessageChannel<T> channel, MessageType type, CommandSender sender, String message, Replacement ... replacements) {
        this.sendLocalized(channel, type, sender, message, (T)null, replacements);
    }

    public <T extends ChannelData> void sendLocalized(MessageChannel<T> channel, MessageType type, CommandSender sender, String message, @Nullable T data, Replacement ... replacements) {
        if (data != null) {
            data.localized(this.loc(), replacements);
        }
        this.send(channel, type, sender, this.loc().localize(message, replacements), data);
    }

    public <T extends ChannelData> void send(MessageChannel<T> channel, MessageType type, CommandSender target, String message) {
        this.send(channel, type, target, message, null);
    }

    public <T extends ChannelData> void send(MessageChannel<T> channel, MessageType type, CommandSender target, String message, @Nullable T data) {
        String coloredMessage = type.forceColor(message);
        coloredMessage = channel.addPrefix(coloredMessage, this.prefix);
        if (data != null) {
            data.formatText(type, channel, this.prefix);
        }
        channel.sendMessage(coloredMessage, this, (CommandSender)(target == null ? Bukkit.getConsoleSender() : target), data);
    }

    public boolean isDefault() {
        return this.ownerPlugin == null;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

