/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.messages;

import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import LandLord.landlord.eldoutilities.messages.MessageType;
import LandLord.landlord.eldoutilities.messages.channeldata.BossBarData;
import LandLord.landlord.eldoutilities.messages.channeldata.ChannelData;
import LandLord.landlord.eldoutilities.messages.channeldata.TitleData;
import LandLord.landlord.eldoutilities.utils.ObjUtil;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MessageChannel<T extends ChannelData> {
    public static final String KEY_PREFIX = "messageChannel";
    public static final MessageChannel<? extends ChannelData> CHAT = new MessageChannel<ChannelData>(){

        @Override
        public void sendMessage(String message, MessageSender sender, CommandSender target, ChannelData data) {
            target.sendMessage(message);
        }

        @Override
        public String addPrefix(String message, String prefix) {
            return prefix + message;
        }
    };
    public static final MessageChannel<TitleData> TITLE = (message, sender, target, data) -> {
        TitleData titleData = data;
        if (titleData == null) {
            titleData = TitleData.DEFAULT;
        }
        if (target instanceof Player) {
            ((Player)target).sendTitle(message, titleData.getOtherLine(), titleData.getFadeIn(), titleData.getStay(), titleData.getFadeOut());
        } else {
            sender.send(CHAT, MessageType.NORMAL, target, message);
        }
    };
    public static final MessageChannel<TitleData> SUBTITLE = (message, sender, target, data) -> {
        TitleData titleData = data;
        if (titleData == null) {
            titleData = TitleData.DEFAULT;
        }
        if (target instanceof Player) {
            ((Player)target).sendTitle(titleData.getOtherLine(), message, titleData.getFadeIn(), titleData.getStay(), titleData.getFadeOut());
        } else {
            sender.send(CHAT, MessageType.NORMAL, target, message);
        }
    };
    public static final MessageChannel<? extends ChannelData> ACTION_BAR = (message, sender, target, data) -> {
        if (target instanceof Player) {
            ((Player)target).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        } else {
            sender.send(CHAT, MessageType.NORMAL, target, message);
        }
    };
    public static final MessageChannel<BossBarData> BOSS_BAR = (message, sender, target, data) -> {
        BossBarData bossBarData = data;
        if (bossBarData == null) {
            bossBarData = BossBarData.DEFAULT;
        }
        if (target instanceof Player) {
            String key = KEY_PREFIX + target.getName() + ThreadLocalRandom.current().nextInt(10000, 99999);
            NamespacedKey barKey = new NamespacedKey(EldoUtilities.getInstanceOwner(), key);
            BossBar bossBar = bossBarData.create(barKey, message);
            bossBar.setProgress(1.0);
            bossBar.addPlayer((Player)target);
            Bukkit.getScheduler().runTaskLater(EldoUtilities.getInstanceOwner(), () -> {
                bossBar.removeAll();
                Bukkit.removeBossBar((NamespacedKey)barKey);
            }, (long)bossBarData.getDuration());
        } else {
            target.sendMessage(message);
        }
    };
    public static final MessageChannel<? extends ChannelData> BROADCAST = new MessageChannel<ChannelData>(){

        @Override
        public void sendMessage(String message, MessageSender sender, CommandSender target, ChannelData data) {
            Bukkit.broadcastMessage((String)message);
        }

        @Override
        public String addPrefix(String message, String prefix) {
            return prefix + message;
        }
    };

    @NotNull
    public static MessageChannel<? extends ChannelData> getChannelByNameOrDefault(@Nullable String name) {
        return ObjUtil.nonNull(MessageChannel.getChannelByName(name), CHAT);
    }

    @Nullable
    public static MessageChannel<? extends ChannelData> getChannelByName(@Nullable String name) {
        if ("CHAT".equalsIgnoreCase(name)) {
            return CHAT;
        }
        if ("TITLE".equalsIgnoreCase(name)) {
            return TITLE;
        }
        if ("SUBTITLE".equalsIgnoreCase(name)) {
            return SUBTITLE;
        }
        if ("ACTION_BAR".equalsIgnoreCase(name)) {
            return ACTION_BAR;
        }
        if ("BOSS_BAR".equalsIgnoreCase(name)) {
            return BOSS_BAR;
        }
        if ("BROADCAST".equalsIgnoreCase(name)) {
            return BROADCAST;
        }
        return null;
    }

    public void sendMessage(String var1, MessageSender var2, CommandSender var3, T var4);

    default public void sendMessage(String message, MessageSender sender, CommandSender target) {
        this.sendMessage(message, sender, target, null);
    }

    default public String addPrefix(String message, String prefix) {
        return message;
    }
}

