/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.logging;

import LandLord.landlord.eldoutilities.configuration.EldoConfig;
import LandLord.landlord.eldoutilities.plugin.EldoPlugin;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public class DebugLogger
extends Logger {
    private static final String DEBUG = "\u00a7b [DEBUG] ";
    private static final String FINE = "\u00a73 [FINE] ";
    private static final String FINER = "\u00a79 [FINER] ";
    private static final String FINEST = "\u00a71 [FINEST] ";
    private final Logger logger;

    public DebugLogger(EldoPlugin plugin, Logger logger) {
        super(plugin.getName(), null);
        this.logger = logger;
        this.setLevel(EldoConfig.getLogLevel((Plugin)plugin));
        this.log(this.getLevel(), "Debug logger initialized. Log Level: " + this.getLevel().getName());
    }

    @Override
    public void log(LogRecord record) {
        int level = record.getLevel().intValue();
        if (level < 800) {
            if (this.getLevel().intValue() > level) {
                return;
            }
            record.setLevel(Level.INFO);
            if (level == Level.CONFIG.intValue()) {
                this.appendPrefix(record, DEBUG);
            } else if (level == Level.FINE.intValue()) {
                this.appendPrefix(record, FINE);
            } else if (level == Level.FINER.intValue()) {
                this.appendPrefix(record, FINER);
            } else if (level == Level.FINEST.intValue()) {
                this.appendPrefix(record, FINEST);
            }
        }
        this.logger.log(record);
    }

    @Override
    public String getName() {
        return this.getParent().getName();
    }

    @Override
    public Logger getParent() {
        return this.logger.getParent();
    }

    @Override
    public void setParent(Logger parent) {
        this.logger.setParent(parent);
    }

    private void appendPrefix(LogRecord record, String prefix) {
        record.setMessage(prefix + record.getMessage());
    }
}

