/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.localization;

import org.bukkit.World;
import org.bukkit.entity.Player;

public final class Replacement {
    private static String format = "%%%s%%";
    private final String key;
    private String value;
    private boolean caseSensitive;

    private Replacement(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Replacement create(String key, String value, char ... formats) {
        Replacement replacement = new Replacement(key, value);
        return replacement.addFormatting(formats);
    }

    public static Replacement create(String key, Double value, char ... formats) {
        return Replacement.create(key, String.format("%.2f", value), formats);
    }

    public static Replacement create(String key, Object value, char ... formats) {
        return Replacement.create(key, value.toString(), formats);
    }

    public static Replacement create(String key, Enum<?> anEnum, char ... formats) {
        return Replacement.create(key, anEnum.name(), formats);
    }

    public static Replacement create(String key, Player player, char ... formats) {
        return Replacement.create(key, player.getName(), formats);
    }

    public static Replacement create(String key, World world, char ... formats) {
        return Replacement.create(key, world.getName(), formats);
    }

    public Replacement addFormatting(char[] format, char ... afterFormat) {
        if (format.length == 0 && afterFormat.length == 0) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        for (char aChar : format) {
            builder.append("\u00a7").append(aChar);
        }
        builder.append(this.value).append("\u00a7r");
        for (char aChar : afterFormat) {
            builder.append("\u00a7").append(aChar);
        }
        this.value = builder.toString();
        return this;
    }

    public Replacement addFormatting(char ... format) {
        return this.addFormatting(format, new char[0]);
    }

    public Replacement matchCase() {
        this.caseSensitive = true;
        return this;
    }

    public String invoke(String string) {
        if (!this.caseSensitive) {
            return string.replaceAll("(?i)" + this.markedKey(), this.value.replace("$", "\\$"));
        }
        return string.replace(this.key, this.value);
    }

    private String markedKey() {
        return String.format(format, this.key);
    }

    public String toString() {
        return "Replacement{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", caseSensitive=" + this.caseSensitive + '}';
    }

    public static void setFormat(String format) {
        Replacement.format = format;
    }
}

