/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.localization;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import LandLord.landlord.eldoutilities.utils.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MessageComposer {
    private final StringBuilder stringBuilder = new StringBuilder();
    private final List<Replacement> replacements = new ArrayList<Replacement>();

    public static MessageComposer create() {
        return new MessageComposer();
    }

    private MessageComposer() {
    }

    public MessageComposer localeCode(String propertyKey, Replacement ... replacements) {
        this.stringBuilder.append(MessageComposer.escape(propertyKey));
        this.replacements.addAll(Arrays.asList(replacements));
        return this;
    }

    public MessageComposer text(String text, Object ... objects) {
        this.stringBuilder.append(String.format(text, objects));
        return this;
    }

    public MessageComposer text(Object object) {
        this.stringBuilder.append(object.toString());
        return this;
    }

    public MessageComposer text(Collection<String> messages) {
        return this.text(messages, "\n");
    }

    public MessageComposer text(Collection<String> messages, String delimiter) {
        this.stringBuilder.append(String.join((CharSequence)delimiter, messages));
        return this;
    }

    public MessageComposer space() {
        this.stringBuilder.append(" ");
        return this;
    }

    public MessageComposer space(int spaces) {
        this.stringBuilder.append(IntStream.range(0, spaces).mapToObj(i -> " ").collect(Collectors.joining()));
        return this;
    }

    public MessageComposer fillLines() {
        return this.fillLines(25);
    }

    public MessageComposer fillLines(int lines) {
        int lineCount = TextUtil.countChars(this.stringBuilder.toString(), '\n') + 1;
        this.prependLines(Math.max(lines - lineCount, 0));
        return this;
    }

    public MessageComposer prependLines(int lines) {
        String newLines = IntStream.range(0, Math.max(lines, 0)).mapToObj(i -> "\n").collect(Collectors.joining());
        this.stringBuilder.insert(0, newLines);
        return this;
    }

    public MessageComposer prependLines() {
        this.prependLines(25);
        return this;
    }

    public MessageComposer newLine() {
        this.stringBuilder.append(String.format("%n", new Object[0]));
        return this;
    }

    public String build() {
        return this.stringBuilder.toString();
    }

    public String buildLocalized(ILocalizer localizer) {
        return localizer.localize(this.stringBuilder.toString(), this.replacements.toArray(new Replacement[0]));
    }

    public static String escape(String propertyKey) {
        return String.format("$%s$", propertyKey);
    }
}

