/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.localization;

import LandLord.landlord.eldoutilities.localization.ILocalizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;

public class Localizer
implements ILocalizer {
    private static final Pattern EMBED_LOCALIZATION_CODE = Pattern.compile("\\$([a-zA-Z0-9_.]+?)\\$");
    private static final Pattern LOCALIZATION_CODE = Pattern.compile("([a-zA-Z0-9_.]+?)");
    private final ResourceBundle fallbackLocaleFile;
    private final Plugin plugin;
    private final String localesPath;
    private final String localesPrefix;
    private final String[] includedLocales;
    private final Pattern localePattern = Pattern.compile("_(([a-zA-Z]{2})(_[a-zA-Z]{2})?)\\.properties");
    private final Map<String, String> runtimeLocaleCodes = new HashMap<String, String>();
    private ResourceBundle localeFile;
    private boolean checked;

    Localizer(Plugin plugin, String localesPath, String localesPrefix, Locale fallbackLocale, String ... includedLocales) {
        this.plugin = plugin;
        this.localesPath = localesPath;
        this.localesPrefix = localesPrefix;
        this.includedLocales = includedLocales;
        this.fallbackLocaleFile = ResourceBundle.getBundle(localesPrefix, fallbackLocale, plugin.getClass().getClassLoader());
        LOCALIZER.put(plugin.getClass(), this);
        this.createDefaults();
    }

    private void createDefaults() {
        HashMap<String, String> locales = new HashMap<String, String>();
        locales.put("error.invalidArguments", "Invalid arguments.\nSyntax: %SYNTAX%");
        locales.put("error.invalidCommand", "Invalid Command");
        locales.put("error.permission", "You do not have the permissionNode to do this. (%PERMISSION%)");
        locales.put("error.invalidRange", "This value is out of range. Min: %MIN% Max: %MAX%");
        locales.put("error.invalidEnumValue", "Invalid input value. Valid inputs are %VALUES%.");
        locales.put("error.invalidMaterial", "Invalid material.");
        locales.put("error.invalidNumber", "Invalid number");
        locales.put("error.invalidBoolean", "Invalid value, %TRUE% or %FALSE%");
        locales.put("error.invalidLength", "This input is too long. Max: %MAX% chars.");
        locales.put("error.notOnline", "Invalid player. This player is not online.");
        locales.put("error.unkownPlayer", "Invalid player. This player has never played on this server.");
        locales.put("error.unkownWorld", "Invalid player. This player has never played on this server.");
        locales.put("error.notAsConsole", "This command can not be executed from console.");
        locales.put("error.onlyPlayer", "This command can only be used by players.");
        locales.put("error.onlyConsole", "This command can only be used by console.");
        locales.put("error.invalidSender", "This command can not be executed from here.");
        locales.put("error.missingArgument", "Argument %INDEX% is accessed but not present.");
        locales.put("error.notAsPlayer", "This command can not be executed as player");
        locales.put("error.tooSmall", "The number is too small. Min: %MIN%");
        locales.put("error.tooLarge", "The number is too Large. Max: %MAX%");
        locales.put("about", "%PLUGIN_NAME% by %AUTHORS%\nVersion: %VERSION%\nSpigot: %WEBSITE%\nSupport: %DISCORD%");
        locales.put("dialog.accept", "accept");
        locales.put("dialog.deny", "deny");
        locales.put("dialog.add", "add");
        locales.put("dialog.remove", "remove");
        locales.put("dialog.leftClickChange", "Left click to change");
        locales.put("dialog.rightClickRemove", "Right click to remove");
        this.addLocaleCodes(locales);
    }

    @Override
    public void setLocale(String language) {
        if (!this.checked) {
            this.createOrUpdateLocaleFiles();
            this.checked = true;
        }
        String localeFile = this.localesPrefix + "_" + language + ".properties";
        try (InputStream stream = Files.newInputStream(Paths.get(this.plugin.getDataFolder().toString(), this.localesPath, localeFile), new OpenOption[0]);){
            this.localeFile = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not load locale file " + Paths.get(this.localesPath, localeFile), e);
            this.localeFile = this.fallbackLocaleFile;
        }
    }

    @Override
    public String getMessage(String key, Replacement ... replacements) {
        String result = null;
        if (this.localeFile.containsKey(key)) {
            result = this.localeFile.getString(key);
            if (result.isEmpty() && this.fallbackLocaleFile.containsKey(key)) {
                result = this.fallbackLocaleFile.getString(key);
            }
        } else if (this.fallbackLocaleFile.containsKey(key)) {
            result = this.fallbackLocaleFile.getString(key);
        }
        if (result == null) {
            this.plugin.getLogger().warning("Key " + key + " is missing in fallback file.");
            result = key;
        }
        return this.invokeReplacements(result, replacements);
    }

    private void createOrUpdateLocaleFiles() {
        boolean mkdir;
        Path messages = Paths.get(this.plugin.getDataFolder().toString(), this.localesPath);
        if (!messages.toFile().exists() && !(mkdir = messages.toFile().mkdir())) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create locale directory.");
            return;
        }
        for (String includedLocale : this.includedLocales) {
            Throwable throwable;
            String filename = this.localesPrefix + "_" + includedLocale + ".properties";
            File localeFile = Paths.get(messages.toString(), filename).toFile();
            if (localeFile.exists()) continue;
            StringBuilder builder = new StringBuilder();
            try {
                throwable = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.plugin.getResource(filename), StandardCharsets.UTF_8));){
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        builder.append(line).append("\n");
                        line = bufferedReader.readLine();
                    }
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not load resource " + filename + ".", e);
            }
            catch (NullPointerException e) {
                this.plugin.getLogger().log(Level.WARNING, "Locale " + includedLocale + " could not be loaded but should exists.", e);
                continue;
            }
            try {
                throwable = null;
                try (OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(localeFile), StandardCharsets.UTF_8);){
                    outputStream.write(builder.toString());
                }
                catch (Throwable line) {
                    throwable = line;
                    throw line;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to create default message file " + localeFile.getName() + ".", e);
                continue;
            }
            this.plugin.getLogger().info("Created default locale " + filename);
        }
        ArrayList<File> localeFiles = new ArrayList<File>();
        try (Stream<Path> message = Files.list(messages);){
            for (Path path : message.collect(Collectors.toList())) {
                if (path.toFile().isDirectory()) continue;
                if (path.toFile().getName().matches(this.localesPrefix + "_[a-zA-Z]{2}(_[a-zA-Z]{2})?\\.properties")) {
                    localeFiles.add(path.toFile());
                    continue;
                }
                this.plugin.getLogger().info(path + " is not a valid message file. Skipped.");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load message files.");
        }
        ResourceBundle defaultBundle = null;
        try {
            defaultBundle = new PropertyResourceBundle(new InputStreamReader(this.plugin.getResource(this.localesPrefix + ".properties"), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not load reference file... This is really bad!", e);
        }
        if (defaultBundle == null) {
            this.plugin.getLogger().warning("No reference locale found. Please report this to the application owner");
            return;
        }
        HashSet<String> defaultKeys = new HashSet<String>(Collections.list(defaultBundle.getKeys()));
        defaultKeys.addAll(this.runtimeLocaleCodes.keySet());
        for (File file : localeFiles) {
            Locale currLocale = this.extractLocale(file.getName());
            ResourceBundle refBundle = null;
            if (currLocale != null) {
                try {
                    refBundle = new PropertyResourceBundle(new InputStreamReader(this.plugin.getResource(this.localesPrefix + "_" + currLocale + ".properties"), StandardCharsets.UTF_8));
                }
                catch (IOException | NullPointerException e) {
                    this.plugin.getLogger().info("\u00a7eNo reference locale found for " + currLocale + ". Using default locale.");
                }
                if (refBundle == null) {
                    refBundle = defaultBundle;
                } else {
                    this.plugin.getLogger().info("\u00a72Found matching locale for " + currLocale);
                }
            } else {
                this.plugin.getLogger().warning("Could not determine locale code of file " + file.getName());
                refBundle = defaultBundle;
            }
            TreeMap<String, String> treemap = new TreeMap<String, String>(String::compareToIgnoreCase);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                Object line = bufferedReader.readLine();
                while (line != null) {
                    String[] split = ((String)line).split("=", 2);
                    if (split.length == 2) {
                        treemap.put(split[0], split[1]);
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not update locale " + file.getName() + ".", e);
                continue;
            }
            Set keys = treemap.keySet();
            boolean updated = false;
            for (String currKey : defaultKeys) {
                if (keys.contains(currKey)) continue;
                String value = "";
                if (refBundle != null) {
                    value = refBundle.containsKey(currKey) ? refBundle.getString(currKey) : this.runtimeLocaleCodes.getOrDefault(currKey, "");
                }
                treemap.put(currKey, value);
                if (!updated) {
                    this.plugin.getLogger().info("\u00a72Updating " + file.getName() + ".");
                }
                this.plugin.getLogger().info("\u00a72Added: \u00a73" + currKey + "\u00a76=\u00a7b" + value.replace("\n", "\\n"));
                updated = true;
            }
            if (updated) {
                try (OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                    outputStream.write("# File automatically updated at " + DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").format(LocalDateTime.now()) + "\n");
                    for (Map.Entry entry : treemap.entrySet()) {
                        outputStream.write((String)entry.getKey() + "=" + ((String)entry.getValue()).replace("\n", "\\n") + "\n");
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not update locale " + file.getName() + ".", e);
                    continue;
                }
                this.plugin.getLogger().info("\u00a72Updated locale " + file.getName() + ". Please check your translation.");
                continue;
            }
            this.plugin.getLogger().info("\u00a72Locale " + file.getName() + " is up to date.");
        }
    }

    private Locale extractLocale(String filename) {
        Matcher matcher = this.localePattern.matcher(filename);
        if (matcher.find()) {
            String group = matcher.group(1);
            String[] s = group.split("_");
            if (s.length == 1) {
                return new Locale(s[0]);
            }
            return new Locale(s[0], s[1]);
        }
        return null;
    }

    @Override
    public String localize(String message, Replacement ... replacements) {
        if (message == null) {
            return null;
        }
        if (!EMBED_LOCALIZATION_CODE.matcher(message).find() && LOCALIZATION_CODE.matcher(message).matches()) {
            message = this.getMessage(message, replacements);
        }
        Matcher matcher = EMBED_LOCALIZATION_CODE.matcher(message);
        ArrayList<String> keys = new ArrayList<String>();
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        String result = message;
        for (String match : keys) {
            result = result.replace("$" + match + "$", this.getMessage(match, replacements));
        }
        if (EMBED_LOCALIZATION_CODE.matcher(result = this.invokeReplacements(result, replacements)).find()) {
            return this.localize(result, replacements);
        }
        return result;
    }

    private String invokeReplacements(String message, Replacement ... replacements) {
        for (Replacement replacement : replacements) {
            message = replacement.invoke(message);
        }
        return message;
    }

    @Override
    public String[] getIncludedLocales() {
        return this.includedLocales;
    }

    @Override
    public void addLocaleCodes(Map<String, String> runtimeLocaleCodes) {
        this.runtimeLocaleCodes.putAll(runtimeLocaleCodes);
    }
}

