/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.localization;

import LandLord.landlord.eldoutilities.localization.DummyLocalizer;
import LandLord.landlord.eldoutilities.localization.Localizer;
import LandLord.landlord.eldoutilities.localization.Replacement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public interface ILocalizer {
    public static final Map<Class<? extends Plugin>, ILocalizer> LOCALIZER = new HashMap<Class<? extends Plugin>, ILocalizer>();
    public static final ILocalizer DEFAULT = new DummyLocalizer();

    public static ILocalizer getPluginLocalizer(Plugin plugin) {
        if (plugin == null) {
            return DEFAULT;
        }
        return ILocalizer.getPluginLocalizer(plugin.getClass());
    }

    public static ILocalizer getPluginLocalizer(Class<? extends Plugin> plugin) {
        if (plugin == null) {
            return DEFAULT;
        }
        return LOCALIZER.getOrDefault(plugin, DEFAULT);
    }

    public static String escape(String string) {
        return String.format("$%s$", string);
    }

    public static ILocalizer create(Plugin plugin, String ... includedLocales) {
        return ILocalizer.create(plugin, "messages", "messages", Locale.US, includedLocales);
    }

    public static ILocalizer create(Plugin plugin, String localesPath, String localesPrefix, Locale fallbackLocale, String ... includedLocales) {
        Localizer localizer = new Localizer(plugin, localesPath, localesPrefix, fallbackLocale, includedLocales);
        LOCALIZER.put(plugin.getClass(), localizer);
        return localizer;
    }

    public void setLocale(String var1);

    public String getMessage(String var1, Replacement ... var2);

    public String[] getIncludedLocales();

    public void addLocaleCodes(Map<String, String> var1);

    public String localize(String var1, Replacement ... var2);
}

