/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.inventory;

import LandLord.landlord.eldoutilities.inventory.InventoryActions;
import LandLord.landlord.eldoutilities.plugin.EldoPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class InventoryActionHandler
implements Listener {
    private static final Map<Class<? extends Plugin>, InventoryActionHandler> PLUGIN_HANDLER = new HashMap<Class<? extends Plugin>, InventoryActionHandler>();
    private final Map<UUID, InventoryActions> inventories = new HashMap<UUID, InventoryActions>();
    private Runnable onClose;

    public InventoryActionHandler() {
        this.onClose = () -> {};
    }

    public InventoryActionHandler(Runnable onClose) {
        this.onClose = () -> {};
        this.onClose = onClose;
    }

    public static InventoryActionHandler create(Plugin plugin) {
        return PLUGIN_HANDLER.computeIfAbsent(plugin.getClass(), k -> {
            InventoryActionHandler handler = new InventoryActionHandler();
            Bukkit.getPluginManager().registerEvents((Listener)handler, plugin);
            return handler;
        });
    }

    public static InventoryActionHandler create(EldoPlugin plugin, Runnable onClose) {
        return PLUGIN_HANDLER.computeIfAbsent(plugin.getClass(), k -> {
            InventoryActionHandler handler = new InventoryActionHandler(onClose);
            plugin.registerListener(handler);
            return handler;
        });
    }

    public static InventoryActionHandler getPluginInventoryHandler(Class<? extends Plugin> plugin) {
        return PLUGIN_HANDLER.computeIfAbsent(plugin, k -> new InventoryActionHandler());
    }

    public InventoryActions wrap(Player player, Inventory inventory) {
        InventoryActions inventoryActions = InventoryActions.of(inventory);
        this.inventories.put(player.getUniqueId(), inventoryActions);
        return inventoryActions;
    }

    public InventoryActions wrap(Player player, Inventory inventory, Consumer<InventoryCloseEvent> onClose) {
        InventoryActions inventoryActions = InventoryActions.of(inventory, onClose);
        this.inventories.put(player.getUniqueId(), inventoryActions);
        return inventoryActions;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.inventories.containsKey(event.getPlayer().getUniqueId())) {
            this.inventories.remove(event.getPlayer().getUniqueId()).onInventoryClose(event);
        }
        this.onClose.run();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.inventories.containsKey(event.getWhoClicked().getUniqueId())) {
            this.inventories.get(event.getWhoClicked().getUniqueId()).onInventoryClick(event);
            event.setCancelled(true);
        }
    }
}

