/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.debug.payload;

import LandLord.landlord.eldoutilities.configuration.EldoConfig;
import LandLord.landlord.eldoutilities.debug.DebugSettings;
import LandLord.landlord.eldoutilities.debug.data.EntryData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public class ConfigDump
extends EntryData {
    public ConfigDump(String path, String content) {
        super(path, content);
    }

    public static EntryData[] create(Plugin plugin, DebugSettings settings) {
        Path root = plugin.getDataFolder().toPath().toAbsolutePath().getParent().getParent();
        EldoConfig mainConfig = EldoConfig.getMainConfig();
        LinkedHashSet<String> configs = new LinkedHashSet<String>();
        if (mainConfig != null) {
            try {
                mainConfig.save();
            }
            catch (Exception e2) {
                plugin.getLogger().log(Level.CONFIG, "something went wrong while saving the config. Skipping", e2);
            }
            configs.addAll(mainConfig.getConfigs().keySet());
        } else {
            configs.add(Paths.get(plugin.getDataFolder().toPath().toString(), "config.yml").toString());
        }
        LinkedList<ConfigDump> dumps = new LinkedList<ConfigDump>();
        for (String config : configs) {
            File currentConfig = Paths.get(root.toString(), config).toFile();
            String content = "Could not read";
            if (currentConfig.exists()) {
                try {
                    content = Files.readAllLines(currentConfig.toPath(), StandardCharsets.UTF_8).stream().collect(Collectors.joining(System.lineSeparator()));
                }
                catch (IOException e3) {
                    plugin.getLogger().info("Could not read config file " + config);
                }
            }
            dumps.add(new ConfigDump(config, content));
        }
        dumps.forEach(e -> e.applyFilter(settings));
        return dumps.toArray(new ConfigDump[0]);
    }
}

