/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.debug;

import LandLord.landlord.eldoutilities.configuration.ConfigFileWrapper;
import LandLord.landlord.eldoutilities.core.EldoUtilities;
import LandLord.landlord.eldoutilities.debug.DebugDataProvider;
import LandLord.landlord.eldoutilities.debug.DebugPayload;
import LandLord.landlord.eldoutilities.debug.DebugSettings;
import LandLord.landlord.eldoutilities.debug.data.DebugPayloadData;
import LandLord.landlord.eldoutilities.debug.data.DebugResponse;
import LandLord.landlord.eldoutilities.debug.data.EntryData;
import LandLord.landlord.eldoutilities.messages.MessageChannel;
import LandLord.landlord.eldoutilities.messages.MessageSender;
import LandLord.landlord.eldoutilities.messages.MessageType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class DebugUtil {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    private DebugUtil() {
    }

    public static void dispatchDebug(CommandSender sender, Plugin plugin, DebugSettings settings) {
        ConfigFileWrapper config = EldoUtilities.getConfiguration();
        MessageSender messageSender = MessageSender.getPluginMessageSender(plugin);
        if (!config.get().getBoolean("debugConsens", false)) {
            String message = "By using this command you agree that we will send data belonging to you to \u00a7lour server\u00a7r.\nWe will only send data when someone executes this command.\nThe data will be handled confidential from our side and will be only available by a hashed key.\nUnless you share this key no one can access it. \u00a7cEveryone who receives this key will have access to your data.\u00a7r\nYou can delete your data at every time with the deletion key. \u00a7cIf you lose or didnt save your key we can not help you.\u00a7r\nYour data will be deleted after \u00a7l\u00a7c14 days\u00a7r.\nThis data includes but is \u00a7l\u00a7cnot\u00a7r limited to:\n  - Installed Plugins and their meta data\n  - Latest log\n  - Server Informations like Worldnames and Playercount\n  - The configuration file or files of the debugged plugin\n  - Additional Data provided by our own plugins.\nWe will filter sensitive data like IPs before sending.\nHowever we \u00a7l\u00a7ccan not\u00a7r and \u00a7l\u00a7cwill not\u00a7r gurantee that we can remove all data which is considered confidential by you.\n\u00a72If you agree please execute this command once again.\n\u00a72This is a one time opt in.\nYou can opt out again in the EldoUtilities config file.";
            messageSender.send(MessageChannel.CHAT, () -> "\u00a76", sender, message);
            config.write(c -> c.set("debugConsens", (Object)true));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            Optional<DebugResponse> debugResponse = DebugUtil.sendDebug(plugin, DebugPayload.create(plugin, settings), settings);
            if (debugResponse.isPresent()) {
                messageSender.send(MessageChannel.CHAT, MessageType.NORMAL, sender, "Your data is available here:\n\u00a76" + settings.getHost() + "/debug/v1/read/" + debugResponse.get().getHash() + "\u00a7r\nYou can delete it via this link:\n\u00a7c" + settings.getHost() + "/debug/v1/delete/" + debugResponse.get().getDeletionHash());
            } else {
                messageSender.send(MessageChannel.CHAT, MessageType.ERROR, sender, "Could not send data. Please try again later");
            }
        });
    }

    @NotNull
    public static EntryData[] getAdditionalPluginMeta(Plugin plugin) {
        LinkedList<EntryData> meta = new LinkedList<EntryData>();
        if (plugin instanceof DebugDataProvider) {
            HashSet<DebugDataProvider> debuged = new HashSet<DebugDataProvider>();
            ArrayDeque<DebugDataProvider> providers = new ArrayDeque<DebugDataProvider>();
            providers.add((DebugDataProvider)plugin);
            debuged.add((DebugDataProvider)plugin);
            while (!providers.isEmpty()) {
                DebugDataProvider provider = (DebugDataProvider)providers.poll();
                for (DebugDataProvider nextProvider : provider.getDebugProviders()) {
                    if (debuged.contains(nextProvider)) {
                        plugin.getLogger().warning("Loop in debug data detected. Instance of class " + nextProvider.getClass().getSimpleName() + " returns a reference to already debugged instance of " + provider.getClass().getSimpleName());
                        continue;
                    }
                    providers.add(nextProvider);
                    debuged.add(nextProvider);
                }
                meta.addAll(Arrays.asList(provider.getDebugInformations()));
            }
        }
        return meta.toArray(new EntryData[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<DebugResponse> sendDebug(Plugin plugin, DebugPayloadData payload, DebugSettings settings) {
        Throwable throwable;
        HttpURLConnection con;
        try {
            URL url = new URL(settings.getHost() + "/debug/v1/submit");
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.FINEST, "Could not open connection.", e);
            return Optional.empty();
        }
        con.setRequestProperty("Content-Type", "application/json; utf-8");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        try {
            throwable = null;
            try (OutputStream outputStream = con.getOutputStream();){
                byte[] input = GSON.toJson((Object)payload).getBytes(StandardCharsets.UTF_8);
                outputStream.write(input, 0, input.length);
            }
            catch (Throwable input) {
                throwable = input;
                throw input;
            }
        }
        catch (IOException e) {
            plugin.getLogger().info("Could not write to connection.");
        }
        try {
            if (con.getResponseCode() != 200) {
                plugin.getLogger().log(Level.FINEST, "Received non 200 request for debug submission.\n" + con.getResponseMessage());
                return Optional.empty();
            }
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.INFO, "Could not read response.", e);
            return Optional.empty();
        }
        try {
            throwable = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder builder = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    builder.append(responseLine.trim());
                }
                Optional<Object> optional = Optional.of(GSON.fromJson(builder.toString(), DebugResponse.class));
                return optional;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.FINEST, "Could not read response.", e);
            return Optional.empty();
        }
    }
}

