/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.database.builder;

import LandLord.landlord.eldoutilities.consumer.ThrowingConsumer;
import LandLord.landlord.eldoutilities.database.DBUtil;
import LandLord.landlord.eldoutilities.database.builder.ParamBuilder;
import LandLord.landlord.eldoutilities.database.builder.QueryBuilderConfig;
import LandLord.landlord.eldoutilities.database.builder.exception.QueryExecutionException;
import LandLord.landlord.eldoutilities.database.builder.exception.WrappedQueryExecutionException;
import LandLord.landlord.eldoutilities.database.builder.stage.ConfigurationStage;
import LandLord.landlord.eldoutilities.database.builder.stage.QueryStage;
import LandLord.landlord.eldoutilities.database.builder.stage.ResultStage;
import LandLord.landlord.eldoutilities.database.builder.stage.RetrievalStage;
import LandLord.landlord.eldoutilities.database.builder.stage.StatementStage;
import LandLord.landlord.eldoutilities.database.builder.stage.UpdateStage;
import LandLord.landlord.eldoutilities.functions.ThrowingFunction;
import LandLord.landlord.eldoutilities.threading.futures.BukkitFutureResult;
import LandLord.landlord.eldoutilities.threading.futures.CompletableBukkitFuture;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.bukkit.plugin.Plugin;

public class QueryBuilder<T>
implements ConfigurationStage<T>,
QueryStage<T>,
StatementStage<T>,
ResultStage<T>,
RetrievalStage<T>,
UpdateStage {
    private final Plugin plugin;
    private final DataSource dataSource;
    private final Queue<QueryTask> tasks = new ArrayDeque<QueryTask>();
    private final QueryExecutionException executionException;
    private final WrappedQueryExecutionException wrappedExecutionException;
    private String currQuery;
    private ThrowingConsumer<PreparedStatement, SQLException> currStatementConsumer;
    private ThrowingFunction<T, ResultSet, SQLException> currResultMapper;
    private QueryBuilderConfig config;

    private QueryBuilder(Plugin plugin, DataSource dataSource, Class<T> clazz) {
        this.plugin = plugin;
        this.dataSource = dataSource;
        this.executionException = new QueryExecutionException("An error occured while executing a query.");
        this.wrappedExecutionException = new WrappedQueryExecutionException("An error occured while executing a query.");
    }

    public static <T> ConfigurationStage<T> builder(Plugin plugin, DataSource source, Class<T> clazz) {
        return new QueryBuilder<T>(plugin, source, clazz);
    }

    public static ConfigurationStage<?> builder(Plugin plugin, DataSource source) {
        return new QueryBuilder(plugin, source, null);
    }

    @Override
    public QueryStage<T> configure(QueryBuilderConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public QueryStage<T> defaultConfig() {
        this.config = QueryBuilderConfig.DEFAULT;
        return this;
    }

    @Override
    public StatementStage<T> query(String query) {
        this.currQuery = query;
        return this;
    }

    @Override
    public ResultStage<T> queryWithoutParams(String query) {
        this.currQuery = query;
        return this.emptyParams();
    }

    @Override
    public ResultStage<T> params(ThrowingConsumer<PreparedStatement, SQLException> stmt) {
        this.currStatementConsumer = stmt;
        return this;
    }

    @Override
    public ResultStage<T> paramsBuilder(ThrowingConsumer<ParamBuilder, SQLException> params) {
        this.currStatementConsumer = stmt -> params.accept(new ParamBuilder((PreparedStatement)stmt));
        return this;
    }

    @Override
    public RetrievalStage<T> readRow(ThrowingFunction<T, ResultSet, SQLException> mapper) {
        this.currResultMapper = mapper;
        this.queueTask();
        return this;
    }

    @Override
    public UpdateStage update() {
        this.currResultMapper = s -> null;
        this.queueTask();
        return this;
    }

    @Override
    public QueryStage<T> append() {
        this.currResultMapper = s -> null;
        this.queueTask();
        return this;
    }

    private void queueTask() {
        this.tasks.add(new QueryTask(this.currQuery, this.currStatementConsumer, this.currResultMapper));
    }

    @Override
    public BukkitFutureResult<List<T>> all() {
        return CompletableBukkitFuture.supplyAsync(this::allSync);
    }

    @Override
    public BukkitFutureResult<List<T>> all(Executor executor) {
        return CompletableBukkitFuture.supplyAsync(this::allSync, executor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> allSync() {
        try (Connection conn = this.dataSource.getConnection();){
            this.autoCommit(conn);
            List results = this.executeAndGetLast(conn).retrieveResults(conn);
            this.commit(conn);
            List list = results;
            return list;
        }
        catch (QueryExecutionException e) {
            this.logDbError(e);
            return Collections.emptyList();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        return Collections.emptyList();
    }

    @Override
    public BukkitFutureResult<Optional<T>> first() {
        return CompletableBukkitFuture.supplyAsync(this::firstSync);
    }

    @Override
    public BukkitFutureResult<Optional<T>> first(Executor executor) {
        return CompletableBukkitFuture.supplyAsync(this::firstSync, executor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<T> firstSync() {
        try (Connection conn = this.dataSource.getConnection();){
            this.autoCommit(conn);
            Optional result = this.executeAndGetLast(conn).retrieveResult(conn);
            this.commit(conn);
            Optional optional = result;
            return optional;
        }
        catch (SQLException e) {
            this.handleException(e);
            return Optional.empty();
        }
    }

    @Override
    public BukkitFutureResult<Integer> execute() {
        return BukkitFutureResult.of(CompletableFuture.supplyAsync(this::executeSync));
    }

    @Override
    public BukkitFutureResult<Integer> execute(Executor executor) {
        return BukkitFutureResult.of(CompletableFuture.supplyAsync(this::executeSync, executor));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeSync() {
        try (Connection conn = this.dataSource.getConnection();){
            this.autoCommit(conn);
            int update = this.executeAndGetLast(conn).update(conn);
            this.commit(conn);
            int n = update;
            return n;
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    private QueryTask executeAndGetLast(Connection conn) throws SQLException {
        while (this.tasks.size() > 1) {
            this.tasks.poll().execute(conn);
        }
        return this.tasks.poll();
    }

    private void logDbError(SQLException e) {
        this.plugin.getLogger().log(Level.SEVERE, "An SQL query occured:\n" + DBUtil.prettyException(e), e);
    }

    private void handleException(SQLException e) {
        if (this.config.isThrowing()) {
            this.wrappedExecutionException.initCause(e);
            throw this.wrappedExecutionException;
        }
        this.executionException.initCause(e);
        this.logDbError(e);
    }

    private void autoCommit(Connection conn) throws SQLException {
        conn.setAutoCommit(!this.config.isAtomic());
    }

    private void commit(Connection conn) throws SQLException {
        if (this.config.isAtomic()) {
            conn.commit();
        }
    }

    private class QueryTask {
        private final String query;
        private final ThrowingConsumer<PreparedStatement, SQLException> statementConsumer;
        private final ThrowingFunction<T, ResultSet, SQLException> resultMapper;
        private final QueryExecutionException executionException;

        public QueryTask(String currQuery, ThrowingConsumer<PreparedStatement, SQLException> statementConsumer, ThrowingFunction<T, ResultSet, SQLException> resultMapper) {
            this.query = currQuery;
            this.statementConsumer = statementConsumer;
            this.resultMapper = resultMapper;
            this.executionException = new QueryExecutionException("An error occured while executing a query.");
        }

        private void initAndThrow(SQLException e) throws SQLException {
            this.executionException.initCause(e);
            throw this.executionException;
        }

        public List<T> retrieveResults(Connection conn) throws SQLException {
            ArrayList results = new ArrayList();
            try (PreparedStatement stmt = conn.prepareStatement(this.query);){
                this.statementConsumer.accept(stmt);
                ResultSet resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    results.add(this.resultMapper.apply(resultSet));
                }
            }
            catch (SQLException e) {
                this.initAndThrow(e);
            }
            return results;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Optional<T> retrieveResult(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.query);){
                this.statementConsumer.accept(stmt);
                ResultSet resultSet = stmt.executeQuery();
                if (!resultSet.next()) return Optional.empty();
                Optional optional = Optional.ofNullable(this.resultMapper.apply(resultSet));
                return optional;
            }
            catch (SQLException e) {
                this.initAndThrow(e);
            }
            return Optional.empty();
        }

        public void execute(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.query);){
                this.statementConsumer.accept(stmt);
                stmt.execute();
            }
            catch (SQLException e) {
                this.initAndThrow(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int update(Connection conn) throws SQLException {
            try (PreparedStatement stmt = conn.prepareStatement(this.query);){
                this.statementConsumer.accept(stmt);
                int n = stmt.executeUpdate();
                return n;
            }
            catch (SQLException e) {
                this.initAndThrow(e);
                return 0;
            }
        }
    }
}

