/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.database.builder;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class ParamBuilder {
    private final PreparedStatement stmt;
    private int index = 1;

    public ParamBuilder(PreparedStatement stmt) {
        this.stmt = stmt;
    }

    private int index() {
        return this.index++;
    }

    public ParamBuilder setNull(int sqlType) throws SQLException {
        this.stmt.setNull(this.index(), sqlType);
        return this;
    }

    public ParamBuilder setBoolean(Boolean x) throws SQLException {
        if (x == null) {
            return this.setNull(16);
        }
        this.stmt.setBoolean(this.index(), x);
        return this;
    }

    public ParamBuilder setByte(Byte x) throws SQLException {
        if (x == null) {
            return this.setNull(-7);
        }
        this.stmt.setByte(this.index(), x);
        return this;
    }

    public ParamBuilder setShort(Short x) throws SQLException {
        if (x == null) {
            return this.setNull(4);
        }
        this.stmt.setShort(this.index(), x);
        return this;
    }

    public ParamBuilder setInt(Integer x) throws SQLException {
        if (x == null) {
            return this.setNull(4);
        }
        this.stmt.setInt(this.index(), x);
        return this;
    }

    public ParamBuilder setLong(Long x) throws SQLException {
        if (x == null) {
            return this.setNull(-5);
        }
        this.stmt.setLong(this.index(), x);
        return this;
    }

    public ParamBuilder setFloat(Float x) throws SQLException {
        if (x == null) {
            return this.setNull(6);
        }
        this.stmt.setFloat(this.index(), x.floatValue());
        return this;
    }

    public ParamBuilder setDouble(Double x) throws SQLException {
        if (x == null) {
            return this.setNull(8);
        }
        this.stmt.setDouble(this.index(), x);
        return this;
    }

    public ParamBuilder setBigDecimal(BigDecimal x) throws SQLException {
        if (x == null) {
            return this.setNull(3);
        }
        this.stmt.setBigDecimal(this.index(), x);
        return this;
    }

    public ParamBuilder setString(String x) throws SQLException {
        if (x == null) {
            return this.setNull(12);
        }
        this.stmt.setString(this.index(), x);
        return this;
    }

    public ParamBuilder setBytes(byte[] x) throws SQLException {
        if (x == null) {
            return this.setNull(-2);
        }
        this.stmt.setBytes(this.index(), x);
        return this;
    }

    public ParamBuilder setDate(Date x) throws SQLException {
        if (x == null) {
            return this.setNull(91);
        }
        this.stmt.setDate(this.index(), x);
        return this;
    }

    public ParamBuilder setTime(Time x) throws SQLException {
        if (x == null) {
            return this.setNull(92);
        }
        this.stmt.setTime(this.index(), x);
        return this;
    }

    public ParamBuilder setTimestamp(Timestamp x) throws SQLException {
        if (x == null) {
            return this.setNull(93);
        }
        this.stmt.setTimestamp(this.index(), x);
        return this;
    }

    public ParamBuilder setAsciiStream(InputStream x, int length) throws SQLException {
        if (x == null) {
            return this.setNull(12);
        }
        this.stmt.setAsciiStream(this.index(), x, length);
        return this;
    }

    public ParamBuilder setBinaryStream(InputStream x, int length) throws SQLException {
        if (x == null) {
            return this.setNull(12);
        }
        this.stmt.setBinaryStream(this.index(), x, length);
        return this;
    }

    public ParamBuilder setObject(Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            return this.setNull(targetSqlType);
        }
        this.stmt.setObject(this.index(), x, targetSqlType);
        return this;
    }

    public ParamBuilder setObject(Object x) throws SQLException {
        this.stmt.setObject(this.index(), x);
        return this;
    }

    public ParamBuilder setCharacterStream(Reader reader, int length) throws SQLException {
        if (reader == null) {
            return this.setNull(12);
        }
        this.stmt.setCharacterStream(this.index(), reader, length);
        return this;
    }

    public ParamBuilder setRef(Ref x) throws SQLException {
        if (x == null) {
            return this.setNull(2006);
        }
        this.stmt.setRef(this.index(), x);
        return this;
    }

    public ParamBuilder setBlob(Blob x) throws SQLException {
        if (x == null) {
            return this.setNull(2004);
        }
        this.stmt.setBlob(this.index(), x);
        return this;
    }

    public ParamBuilder setClob(Clob x) throws SQLException {
        if (x == null) {
            return this.setNull(2005);
        }
        this.stmt.setClob(this.index(), x);
        return this;
    }

    public ParamBuilder setArray(Array x) throws SQLException {
        if (x == null) {
            return this.setNull(2003);
        }
        this.stmt.setArray(this.index(), x);
        return this;
    }

    public ParamBuilder setURL(URL x) throws SQLException {
        if (x == null) {
            return this.setNull(70);
        }
        this.stmt.setURL(this.index(), x);
        return this;
    }

    public ParamBuilder setRowId(RowId x) throws SQLException {
        if (x == null) {
            return this.setNull(-8);
        }
        this.stmt.setRowId(this.index(), x);
        return this;
    }

    public ParamBuilder setNString(String value) throws SQLException {
        if (value == null) {
            return this.setNull(-9);
        }
        this.stmt.setNString(this.index(), value);
        return this;
    }

    public ParamBuilder setNCharacterStream(Reader value, long length) throws SQLException {
        if (value == null) {
            return this.setNull(12);
        }
        this.stmt.setNCharacterStream(this.index(), value, length);
        return this;
    }

    public ParamBuilder setNClob(NClob value) throws SQLException {
        if (value == null) {
            return this.setNull(2011);
        }
        this.stmt.setNClob(this.index(), value);
        return this;
    }

    public ParamBuilder setClob(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return this.setNull(12);
        }
        this.stmt.setClob(this.index(), reader, length);
        return this;
    }

    public ParamBuilder setBlob(InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            return this.setNull(12);
        }
        this.stmt.setBlob(this.index(), inputStream, length);
        return this;
    }

    public ParamBuilder setNClob(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return this.setNull(12);
        }
        this.stmt.setNClob(this.index(), reader, length);
        return this;
    }

    public ParamBuilder setSQLXML(SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            return this.setNull(2009);
        }
        this.stmt.setSQLXML(this.index(), xmlObject);
        return this;
    }

    public ParamBuilder setObject(Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x == null) {
            return this.setNull(targetSqlType);
        }
        this.stmt.setObject(this.index(), x, targetSqlType, scaleOrLength);
        return this;
    }

    public ParamBuilder setAsciiStream(InputStream x, long length) throws SQLException {
        if (x == null) {
            return this.setNull(12);
        }
        this.stmt.setAsciiStream(this.index(), x, length);
        return this;
    }

    public ParamBuilder setBinaryStream(InputStream x, long length) throws SQLException {
        if (x == null) {
            return this.setNull(-4);
        }
        this.stmt.setBinaryStream(this.index(), x, length);
        return this;
    }

    public ParamBuilder setCharacterStream(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return this.setNull(-1);
        }
        this.stmt.setCharacterStream(this.index(), reader, length);
        return this;
    }

    public ParamBuilder setAsciiStream(InputStream x) throws SQLException {
        if (x == null) {
            return this.setNull(-1);
        }
        this.stmt.setAsciiStream(this.index(), x);
        return this;
    }

    public ParamBuilder setBinaryStream(InputStream x) throws SQLException {
        if (x == null) {
            return this.setNull(-4);
        }
        this.stmt.setBinaryStream(this.index(), x);
        return this;
    }

    public ParamBuilder setCharacterStream(Reader reader) throws SQLException {
        if (reader == null) {
            return this.setNull(-1);
        }
        this.stmt.setCharacterStream(this.index(), reader);
        return this;
    }

    public ParamBuilder setNCharacterStream(Reader value) throws SQLException {
        if (value == null) {
            return this.setNull(12);
        }
        this.stmt.setNCharacterStream(this.index(), value);
        return this;
    }

    public ParamBuilder setClob(Reader reader) throws SQLException {
        if (reader == null) {
            return this.setNull(2005);
        }
        this.stmt.setClob(this.index(), reader);
        return this;
    }

    public ParamBuilder setBlob(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            return this.setNull(12);
        }
        this.stmt.setBlob(this.index(), inputStream);
        return this;
    }

    public ParamBuilder setNClob(Reader reader) throws SQLException {
        if (reader == null) {
            return this.setNull(12);
        }
        this.stmt.setNClob(this.index(), reader);
        return this;
    }

    public ParamBuilder setObject(Object x, SQLType targetSqlType) throws SQLException {
        if (x == null) {
            return this.setNull(targetSqlType.getVendorTypeNumber());
        }
        this.stmt.setObject(this.index(), x, targetSqlType);
        return this;
    }
}

