/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.database;

import LandLord.landlord.eldoutilities.database.DBUtil;
import LandLord.landlord.eldoutilities.database.builder.QueryBuilder;
import LandLord.landlord.eldoutilities.database.builder.stage.ConfigurationStage;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.bukkit.plugin.Plugin;

public class QueryObject {
    private final Plugin plugin;
    private final DataSource dataSource;

    public QueryObject(Plugin plugin, DataSource dataSource) {
        this.plugin = plugin;
        this.dataSource = dataSource;
    }

    protected <T> ConfigurationStage<T> queryBuilder(Class<T> clazz) {
        return QueryBuilder.builder(this.plugin, this.dataSource, clazz);
    }

    public void logDbError(String message, SQLException e) {
        this.plugin.getLogger().log(Level.SEVERE, message + ":\n" + DBUtil.prettyException(e), e);
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

