/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.crossversion.builder;

import LandLord.landlord.eldoutilities.crossversion.ServerVersion;
import LandLord.landlord.eldoutilities.crossversion.function.VersionFunction;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;

public class FunctionBuilder<A, R> {
    private final Map<ServerVersion, Function<A, R>> functions = new EnumMap<ServerVersion, Function<A, R>>(ServerVersion.class);

    protected FunctionBuilder() {
    }

    public FunctionBuilder<A, R> addVersionFunction(Function<A, R> function, ServerVersion ... version) {
        for (ServerVersion serverVersion : version) {
            this.functions.put(serverVersion, function);
        }
        return this;
    }

    public FunctionBuilder<A, R> addVersionFunctionBetween(ServerVersion oldest, ServerVersion newest, Function<A, R> function) {
        this.addVersionFunction(function, ServerVersion.versionsBetween(oldest, newest));
        return this;
    }

    public VersionFunction<A, R> build() {
        return new VersionFunction<A, R>(this.functions);
    }
}

