/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.crossversion;

import LandLord.landlord.eldoutilities.container.Triple;
import LandLord.landlord.eldoutilities.crossversion.UnsupportedVersionException;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public enum ServerVersion {
    MC_UNKOWN(Triple.of(0, 0, 0)),
    MC_1_0(Triple.of(1, 0, 0)),
    MC_1_1(Triple.of(1, 1, 0)),
    MC_1_2(Triple.of(1, 2, 0)),
    MC_1_3(Triple.of(1, 3, 0)),
    MC_1_4(Triple.of(1, 4, 0)),
    MC_1_5(Triple.of(1, 5, 0)),
    MC_1_6(Triple.of(1, 6, 0)),
    MC_1_7(Triple.of(1, 7, 0)),
    MC_1_8(Triple.of(1, 8, 0)),
    MC_1_9(Triple.of(1, 9, 0)),
    MC_1_10(Triple.of(1, 10, 0)),
    MC_1_11(Triple.of(1, 11, 0)),
    MC_1_12(Triple.of(1, 12, 0)),
    MC_1_13(Triple.of(1, 13, 0)),
    MC_1_14(Triple.of(1, 14, 0)),
    MC_1_15(Triple.of(1, 15, 0)),
    MC_1_16(Triple.of(1, 16, 0)),
    MC_1_17(Triple.of(1, 17, 0)),
    MC_1_18(Triple.of(1, 18, 0)),
    MC_1_19(Triple.of(1, 19, 0)),
    MC_1_20(Triple.of(1, 20, 0));

    public static final ServerVersion CURRENT_VERSION;
    private static final Pattern VERSION_PATTERN;
    private final Triple<Integer, Integer, Integer> version;

    private ServerVersion(Triple<Integer, Integer, Integer> version) {
        this.version = version;
    }

    public static ServerVersion getVersion() {
        Optional<Triple<Integer, Integer, Integer>> version = ServerVersion.extractVersion();
        if (!version.isPresent()) {
            return MC_UNKOWN;
        }
        for (ServerVersion value : ServerVersion.values()) {
            if (!((Integer)value.version.first).equals(version.get().first) || !((Integer)value.version.second).equals(version.get().second)) continue;
            return value;
        }
        Bukkit.getLogger().warning("Could not determine server Version.");
        return MC_UNKOWN;
    }

    public static Optional<Triple<Integer, Integer, Integer>> extractVersion() {
        Matcher matcher = VERSION_PATTERN.matcher(Bukkit.getServer().getBukkitVersion());
        if (matcher.find()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
            return Optional.of(new Triple<Integer, Integer, Integer>(major, minor, patch));
        }
        return Optional.empty();
    }

    public static boolean between(ServerVersion oldest, ServerVersion newest, ServerVersion current) {
        Integer currentMajor = (Integer)current.version.first;
        Integer oldestMajor = (Integer)oldest.version.first;
        Integer newestMajor = (Integer)newest.version.first;
        Integer currentMinor = (Integer)current.version.second;
        Integer oldestMinor = (Integer)oldest.version.second;
        Integer newestMinor = (Integer)newest.version.second;
        if (currentMajor < oldestMajor || currentMajor > newestMajor) {
            return false;
        }
        return currentMinor >= oldestMinor && currentMinor <= newestMinor;
    }

    public static ServerVersion[] versionsBetween(ServerVersion oldest, ServerVersion newest) {
        return (ServerVersion[])Arrays.stream(ServerVersion.values()).filter(v -> v.between(oldest, newest)).toArray(ServerVersion[]::new);
    }

    public static void forceVersion(ServerVersion oldest, ServerVersion newest) {
        if (CURRENT_VERSION.between(oldest, newest)) {
            return;
        }
        throw new UnsupportedVersionException();
    }

    public boolean between(ServerVersion oldest, ServerVersion newest) {
        return ServerVersion.between(oldest, newest, this);
    }

    public String version() {
        return this.version.first + "." + this.version.second;
    }

    static {
        VERSION_PATTERN = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})(?:\\.([0-9]{1,3}))?");
        CURRENT_VERSION = Bukkit.getServer() != null ? ServerVersion.getVersion() : MC_UNKOWN;
    }
}

