/*
 * Decompiled with CFR 0.152.
 */
package LandLord.landlord.eldoutilities.core.commands;

import LandLord.landlord.eldoutilities.debug.DebugSettings;
import LandLord.landlord.eldoutilities.debug.DebugUtil;
import LandLord.landlord.eldoutilities.messages.MessageChannel;
import LandLord.landlord.eldoutilities.messages.MessageType;
import LandLord.landlord.eldoutilities.simplecommands.EldoCommand;
import LandLord.landlord.eldoutilities.simplecommands.TabCompleteUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EldoDebug
extends EldoCommand {
    private List<String> plugins;

    public EldoDebug(Plugin plugin) {
        super(plugin);
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (this.denyAccess(sender, "de.eldoria.eldoutilitites.debug")) {
            return true;
        }
        if (this.argumentsInvalid(sender, args, 1, "<plugin name>")) {
            return true;
        }
        @NotNull Plugin[] plugins = Bukkit.getPluginManager().getPlugins();
        Plugin plugin = null;
        for (Plugin pl : plugins) {
            if (!pl.getName().equalsIgnoreCase(args[0])) continue;
            plugin = pl;
            break;
        }
        if (plugin == null) {
            this.messageSender().send(MessageChannel.CHAT, MessageType.ERROR, sender, "Invalid plugin");
            return true;
        }
        DebugUtil.dispatchDebug(sender, plugin, DebugSettings.DEFAULT);
        return true;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return TabCompleteUtil.complete(args[0], this.getPlugins());
        }
        return Collections.emptyList();
    }

    private List<String> getPlugins() {
        if (this.plugins == null) {
            this.plugins = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getName).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.plugins);
    }
}

